/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import toast.specialAI.EffectHelper;
import toast.specialAI.ai.special.ISpecialAI;

public class EntityAIThief
extends EntityAIBase
implements ISpecialAI {
    private int WEIGHT;
    protected EntityLiving theEntity;
    private EntityAIAvoidEntity aiAvoid;

    public EntityAIThief() {
    }

    private EntityAIThief(EntityLiving entity, float avoidRange) {
        this.theEntity = entity;
        if (entity instanceof EntityCreature) {
            this.aiAvoid = new EntityAIAvoidEntity((EntityCreature)entity, EntityPlayer.class, avoidRange, 1.0, 1.2);
        }
        this.func_75248_a(3);
    }

    @Override
    public String getName() {
        return "thief";
    }

    @Override
    public int getWeight() {
        return this.WEIGHT;
    }

    @Override
    public void setWeight(int weight) {
        this.WEIGHT = weight;
    }

    @Override
    public void addTo(EntityLiving entity, NBTTagCompound aiTag) {
        entity.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIThief(entity, aiTag.func_74760_g(this.getName())));
    }

    @Override
    public void save(NBTTagCompound aiTag) {
        aiTag.func_74776_a(this.getName(), 16.0f);
    }

    @Override
    public boolean isSaved(NBTTagCompound aiTag) {
        return aiTag.func_74760_g(this.getName()) > 0.0f;
    }

    @Override
    public void initialize(EntityLiving entity) {
        entity.func_70062_b(0, (ItemStack)null);
        ItemStack helmet = new ItemStack((Item)Items.field_151024_Q);
        helmet.func_151001_c("Thief's Cap");
        EffectHelper.addModifier(helmet, SharedMonsterAttributes.field_111263_d, 0.1, 1);
        Items.field_151024_Q.func_82813_b(helmet, 1056804);
        entity.func_70062_b(4, helmet);
        entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(new AttributeModifier(UUID.randomUUID(), "Thief speed boost", 0.2, 1));
        entity.func_98053_h(false);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.theEntity.func_70638_az();
        if (target == null || target instanceof EntityPlayer && target.func_110143_aJ() > target.func_110138_aP() / 2.0f) {
            if (this.theEntity.func_71124_b(0) == null) {
                return target != null && this.hasItems((EntityPlayer)target);
            }
            if (this.aiAvoid != null) {
                try {
                    return this.aiAvoid.func_75250_a();
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        return false;
    }

    public void func_75249_e() {
        if (this.theEntity.func_71124_b(0) == null) {
            this.theEntity.func_70661_as().func_75497_a((Entity)this.theEntity.func_70638_az(), 1.2);
        } else if (this.aiAvoid != null) {
            try {
                this.aiAvoid.func_75249_e();
            }
            catch (Exception ex) {
                this.theEntity.func_70661_as().func_75499_g();
            }
        }
    }

    public boolean func_75253_b() {
        return !this.theEntity.func_70661_as().func_75500_f();
    }

    public void func_75246_d() {
        if (this.theEntity.func_71124_b(0) == null) {
            EntityLivingBase target = this.theEntity.func_70638_az();
            if (target == null) {
                return;
            }
            this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
            double range = this.theEntity.field_70130_N * 2.0f * this.theEntity.field_70130_N * 2.0f + target.field_70130_N;
            if (this.theEntity.func_70092_e(target.field_70165_t, target.field_70121_D.field_72338_b, target.field_70161_v) <= range) {
                target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.theEntity), 1.0f);
                this.theEntity.func_70062_b(0, this.removeRandomItem((EntityPlayer)target));
                this.theEntity.func_96120_a(0, 2.0f);
                this.theEntity.func_110163_bv();
                this.theEntity.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 60, 0));
                this.theEntity.func_70661_as().func_75499_g();
            } else if (this.theEntity.func_70661_as().func_75500_f()) {
                this.theEntity.func_70661_as().func_75497_a((Entity)target, 1.2);
            }
        } else if (this.aiAvoid != null) {
            try {
                this.aiAvoid.func_75246_d();
            }
            catch (Exception ex) {
                this.theEntity.func_70661_as().func_75499_g();
            }
        }
    }

    public void func_75251_c() {
        if (this.aiAvoid != null) {
            try {
                this.aiAvoid.func_75251_c();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean hasItems(EntityPlayer player) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null) continue;
            return true;
        }
        return false;
    }

    private ItemStack removeRandomItem(EntityPlayer player) {
        int count = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            if (player.field_71071_by.func_70301_a(i) == null) continue;
            ++count;
        }
        if (count > 0) {
            count = this.theEntity.func_70681_au().nextInt(count);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = player.field_71071_by.func_70301_a(i);
                if (item == null || --count >= 0) continue;
                player.field_71071_by.func_70299_a(i, (ItemStack)null);
                return item;
            }
        }
        return null;
    }
}

