/*
 * Decompiled with CFR 0.152.
 */
package toast.specialAI.ai.special;

import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import toast.specialAI.ai.special.EntityAIBarrage;
import toast.specialAI.ai.special.EntityAICharge;
import toast.specialAI.ai.special.EntityAIJump;
import toast.specialAI.ai.special.EntityAILeap;
import toast.specialAI.ai.special.EntityAIShaman;
import toast.specialAI.ai.special.EntityAISpawner;
import toast.specialAI.ai.special.EntityAISprint;
import toast.specialAI.ai.special.EntityAIThief;
import toast.specialAI.ai.special.EntityAIThrow;
import toast.specialAI.ai.special.EntityAIThrowPlayer;
import toast.specialAI.ai.special.ISpecialAI;

public class SpecialAIHandler {
    public static final ISpecialAI[] SPECIAL_AI_LIST = new ISpecialAI[]{new EntityAICharge(), new EntityAISprint(), new EntityAIJump(), new EntityAILeap(), new EntityAIBarrage(), new EntityAISpawner(), new EntityAIShaman(), new EntityAIThrow(), new EntityAIThrowPlayer(), new EntityAIThief()};
    public static int AI_WEIGHT;

    public static void saveSpecialAI(EntityLiving entity, NBTTagCompound aiTag) {
        if (AI_WEIGHT > 0) {
            int choice = entity.func_70681_au().nextInt(AI_WEIGHT);
            int index = SPECIAL_AI_LIST.length;
            while (index-- > 0) {
                if ((choice -= SPECIAL_AI_LIST[index].getWeight()) >= 0) continue;
                SPECIAL_AI_LIST[index].save(aiTag);
                return;
            }
        }
    }

    public static void addSpecialAI(EntityLiving entity, NBTTagCompound tag, boolean init) {
        for (ISpecialAI ai : SPECIAL_AI_LIST) {
            if (!ai.isSaved(tag)) continue;
            ai.addTo(entity, tag);
            if (!init) continue;
            ai.initialize(entity);
        }
    }
}

