/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.tileentity;

import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.DoorRegistry;
import net.malisis.doors.door.movement.FenceGateMovement;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FenceGateTileEntity
extends DoorTileEntity {
    private Block camoBlock = Blocks.field_150344_f;
    private int camoMeta = 0;
    private boolean isCamo = false;
    private boolean isWall = false;

    public FenceGateTileEntity() {
        DoorDescriptor descriptor = new DoorDescriptor();
        descriptor.setMovement(DoorRegistry.getMovement(FenceGateMovement.class));
        this.setDescriptor(descriptor);
    }

    public boolean isWall() {
        return this.isWall;
    }

    public IIcon getCamoIcon() {
        return this.camoBlock.func_149691_a(2, this.camoMeta);
    }

    public int getCamoColor() {
        int ox = 0;
        int oz = 0;
        if (this.getDirection() == 1 || this.getDirection() == 3) {
            oz = 1;
        } else {
            ox = 1;
        }
        return this.isCamo ? this.camoBlock.func_149720_d((IBlockAccess)this.func_145831_w(), this.field_145851_c - ox, this.field_145848_d, this.field_145849_e - oz) : 0xFFFFFF;
    }

    @Override
    public FenceGateTileEntity getDoubleDoor() {
        if (!this.descriptor.isDoubleDoor()) {
            return null;
        }
        int dir = this.getDirection();
        TileEntity te = null;
        if (dir == 1 || dir == 3) {
            te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor((FenceGateTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
            te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            if (te instanceof DoorTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
        } else {
            te = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
            te = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            if (te instanceof FenceGateTileEntity && this.isMatchingDoubleDoor((DoorTileEntity)te)) {
                return (FenceGateTileEntity)te;
            }
        }
        return null;
    }

    @Override
    public boolean isMatchingDoubleDoor(DoorTileEntity te) {
        if (this.func_145838_q() != te.func_145838_q()) {
            return false;
        }
        if ((this.getDirection() == 1 || this.getDirection() == 3) != (te.getDirection() == 1 || te.getDirection() == 3)) {
            return false;
        }
        if (this.getMovement() != te.getMovement()) {
            return false;
        }
        return (this.func_145832_p() & 4) == (te.func_145832_p() & 4);
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public void updateCamo(World world, int x, int y, int z) {
        int ox = 0;
        int oz = 0;
        if (this.getDirection() == 1 || this.getDirection() == 3) {
            oz = 1;
        } else {
            ox = 1;
        }
        Block b1 = world.func_147439_a(this.field_145851_c - ox, y, this.field_145849_e - oz);
        Block b2 = world.func_147439_a(this.field_145851_c + ox, y, this.field_145849_e + oz);
        int meta1 = world.func_72805_g(this.field_145851_c - ox, y, this.field_145849_e - oz);
        int meta2 = world.func_72805_g(this.field_145851_c + ox, y, this.field_145849_e + oz);
        boolean bl = this.isWall = b1 == Blocks.field_150463_bK || b2 == Blocks.field_150463_bK;
        if (((Boolean)MalisisDoorsSettings.enableCamoFenceGate.get()).booleanValue() && b1 == b2 && meta1 == meta2 && (this.isWall || b1.func_149686_d()) && !b1.isAir((IBlockAccess)world, this.field_145851_c - ox, y, this.field_145849_e - oz)) {
            this.isCamo = true;
            this.camoBlock = b1;
            this.camoMeta = meta1;
        } else {
            this.isCamo = false;
            this.camoBlock = Blocks.field_150344_f;
            this.camoMeta = 0;
        }
        world.func_147471_g(x, y, z);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isWall = nbt.func_74767_n("isWall");
        int blockID = nbt.func_74762_e("camoBlock");
        if (blockID == 0 || !((Boolean)MalisisDoorsSettings.enableCamoFenceGate.get()).booleanValue()) {
            this.isCamo = false;
            this.camoBlock = Blocks.field_150344_f;
            this.camoMeta = 0;
        } else {
            this.isCamo = nbt.func_74767_n("isCamo");
            this.camoBlock = Block.func_149729_e((int)blockID);
            this.camoMeta = nbt.func_74762_e("camoMeta");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isCamo", this.isCamo);
        nbt.func_74768_a("camoBlock", Block.field_149771_c.func_148757_b((Object)this.camoBlock));
        nbt.func_74768_a("camoMeta", this.camoMeta);
        nbt.func_74757_a("isWall", this.isWall);
    }
}

