/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.client.ClientUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEIRefineryHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 26, 30, 18), "ieRefinery", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (DieselHandler.RefineryRecipe r : DieselHandler.refineryList) {
                if (r == null) continue;
                this.arecipes.add(new CachedRefineryRecipe(r));
            }
        }
        FluidStack fs = null;
        if (outputId == "liquid" && results != null && results.length > 0 && results[0] instanceof FluidStack) {
            fs = (FluidStack)results[0];
        }
        if (outputId == "item" && results != null && results.length > 0 && results[0] instanceof ItemStack && FluidContainerRegistry.isFilledContainer((ItemStack)((ItemStack)results[0]))) {
            fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)results[0]));
        }
        if (fs != null) {
            for (DieselHandler.RefineryRecipe r : DieselHandler.refineryList) {
                if (r == null || !r.output.isFluidEqual(fs)) continue;
                this.arecipes.add(new CachedRefineryRecipe(r));
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        FluidStack fs = null;
        if (inputId == "liquid" && ingredients != null && ingredients.length > 0 && ingredients[0] instanceof FluidStack) {
            fs = (FluidStack)ingredients[0];
        }
        if (inputId == "item" && ingredients != null && ingredients.length > 0 && ingredients[0] instanceof ItemStack && FluidContainerRegistry.isFilledContainer((ItemStack)((ItemStack)ingredients[0]))) {
            fs = FluidContainerRegistry.getFluidForFilledItem((ItemStack)((ItemStack)ingredients[0]));
        }
        if (fs != null) {
            for (DieselHandler.RefineryRecipe r : DieselHandler.refineryList) {
                if (r == null || !r.input0.isFluidEqual(fs) && !r.input1.isFluidEqual(fs)) continue;
                this.arecipes.add(new CachedRefineryRecipe(r));
            }
        }
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"tile.ImmersiveEngineering.metalMultiblock.refinery.name");
    }

    public String getGuiTexture() {
        return "immersiveengineering:textures/gui/refinery.png";
    }

    public String getOverlayIdentifier() {
        return "ieRefinery";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        CachedRefineryRecipe r = (CachedRefineryRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 176) / 2;
            FluidStack fs = null;
            if (localPoint.x > gl + 12 && localPoint.x <= gl + 12 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 11 && localPoint.y <= gt + 64 * (recipe % 2) + 11 + 47) {
                fs = r.fluid0;
            } else if (localPoint.x > gl + 60 && localPoint.x <= gl + 60 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 11 && localPoint.y <= gt + 64 * (recipe % 2) + 11 + 47) {
                fs = r.fluid1;
            } else if (localPoint.x > gl + 108 && localPoint.x <= gl + 108 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 11 && localPoint.y <= gt + 64 * (recipe % 2) + 1 + 47) {
                fs = r.fluidOut;
            }
            if (fs != null && (button == 0 ? GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fs}) : button == 1 && GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{fs}))) {
                return true;
            }
        }
        return super.mouseClicked(gui, button, recipe);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> list, int recipe) {
        CachedRefineryRecipe r = (CachedRefineryRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            Point localPoint = GuiDraw.getMousePosition();
            int gl = (gui.field_146294_l - 176) / 2;
            int gt = (gui.field_146295_m - 134) / 2;
            if (r.fluid0 != null && localPoint.x > gl + 12 && localPoint.x <= gl + 12 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 11 && localPoint.y <= gt + 64 * (recipe % 2) + 11 + 47) {
                list.add(r.fluid0.getLocalizedName());
                list.add(r.fluid0.amount + " mB");
            }
            if (r.fluid1 != null && localPoint.x > gl + 60 && localPoint.x <= gl + 60 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 11 && localPoint.y <= gt + 64 * (recipe % 2) + 11 + 47) {
                list.add(r.fluid1.getLocalizedName());
                list.add(r.fluid1.amount + " mB");
            }
            if (r.fluidOut != null && localPoint.x > gl + 108 && localPoint.x <= gl + 108 + 16 && localPoint.y > gt + 64 * (recipe % 2) + 11 && localPoint.y <= gt + 64 * (recipe % 2) + 11 + 47) {
                list.add(r.fluidOut.getLocalizedName());
                list.add(r.fluidOut.amount + " mB");
            }
        }
        return super.handleTooltip(gui, list, recipe);
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-5, (int)0, (int)0, (int)8, (int)176, (int)68);
        CachedRefineryRecipe r = (CachedRefineryRecipe)((Object)this.arecipes.get(recipe % this.arecipes.size()));
        if (r != null) {
            int h;
            if (r.fluid0 != null) {
                h = (int)Math.max(1.0f, 47.0f * ((float)r.fluid0.amount / 12000.0f));
                ClientUtils.drawRepeatedFluidIcon(r.fluid0.getFluid(), 8, 59 - h, 16, h);
            }
            if (r.fluid1 != null) {
                h = (int)Math.max(1.0f, 47.0f * ((float)r.fluid1.amount / 12000.0f));
                ClientUtils.drawRepeatedFluidIcon(r.fluid1.getFluid(), 56, 59 - h, 16, h);
            }
            if (r.fluidOut != null) {
                h = (int)Math.max(1.0f, 47.0f * ((float)r.fluidOut.amount / 12000.0f));
                ClientUtils.drawRepeatedFluidIcon(r.fluidOut.getFluid(), 104, 59 - h, 16, h);
            }
        }
        ClientUtils.bindTexture(this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)6, (int)10, (int)177, (int)31, (int)20, (int)51);
        GuiDraw.drawTexturedModalRect((int)54, (int)10, (int)177, (int)31, (int)20, (int)51);
        GuiDraw.drawTexturedModalRect((int)102, (int)10, (int)177, (int)31, (int)20, (int)51);
    }

    public class CachedRefineryRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        FluidStack fluid0;
        FluidStack fluid1;
        FluidStack fluidOut;

        public CachedRefineryRecipe(DieselHandler.RefineryRecipe recipe) {
            super((TemplateRecipeHandler)NEIRefineryHandler.this);
            this.fluid0 = recipe.input0;
            this.fluid1 = recipe.input1;
            this.fluidOut = recipe.output;
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

