/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public abstract class TileEntityImmersiveConnectable
extends TileEntityIEBase
implements IImmersiveConnectable {
    protected WireType limitType = null;

    protected boolean canTakeLV() {
        return false;
    }

    protected boolean canTakeMV() {
        return false;
    }

    protected boolean canTakeHV() {
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ImmersiveNetHandler.INSTANCE.clearAllConnectionsFor(Utils.toCC(this), this.field_145850_b);
        }
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean isEnergyOutput() {
        return false;
    }

    @Override
    public int outputEnergy(int amount, boolean simulate, int energyType) {
        return 0;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType == WireType.STEEL && !this.canTakeHV()) {
            return false;
        }
        if (cableType == WireType.ELECTRUM && !this.canTakeMV()) {
            return false;
        }
        if (cableType == WireType.COPPER && !this.canTakeLV()) {
            return false;
        }
        if (cableType == WireType.STRUCTURE_ROPE) {
            return false;
        }
        if (cableType == WireType.STRUCTURE_STEEL) {
            return false;
        }
        return this.limitType == null || this.limitType == cableType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        this.limitType = cableType;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        if (ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this)).isEmpty() && (type == this.limitType || type == null)) {
            this.limitType = null;
        }
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            NBTTagList connectionList = new NBTTagList();
            List<ImmersiveNetHandler.Connection> conL = ImmersiveNetHandler.INSTANCE.getConnections(this.field_145850_b, Utils.toCC(this));
            for (ImmersiveNetHandler.Connection con : conL) {
                connectionList.func_74742_a((NBTBase)con.writeToNBT());
            }
            nbttagcompound.func_74782_a("connectionList", (NBTBase)connectionList);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 3, nbttagcompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            NBTTagList connectionList = nbt.func_150295_c("connectionList", 10);
            ImmersiveNetHandler.INSTANCE.clearConnectionsOriginatingFrom(Utils.toCC(this), this.field_145850_b);
            for (int i = 0; i < connectionList.func_74745_c(); ++i) {
                NBTTagCompound conTag = connectionList.func_150305_b(i);
                ImmersiveNetHandler.Connection con = ImmersiveNetHandler.Connection.readFromNBT(conTag);
                if (con != null) {
                    ImmersiveNetHandler.INSTANCE.addConnection(this.field_145850_b, Utils.toCC(this), con);
                    continue;
                }
                IELogger.error("CLIENT read connection as null");
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        try {
            if (nbt.func_74764_b("limitType")) {
                this.limitType = ApiUtils.getWireTypeFromNBT(nbt, "limitType");
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error reading NBT. You shoudl probably report this.");
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        try {
            if (this.limitType != null) {
                nbt.func_74778_a("limitType", this.limitType.getUniqueName());
            }
            if (this.field_145850_b != null) {
                nbt.func_74783_a("prevPos", new int[]{this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e});
            }
        }
        catch (Exception e) {
            IELogger.error("TileEntityImmersiveConenctable encountered MASSIVE error writing NBT. You shoudl probably report this.");
        }
    }
}

