/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.common.blocks.TileEntityImmersiveConnectable;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class TileEntityBreakerSwitch
extends TileEntityImmersiveConnectable {
    public int sideAttached = 0;
    public int facing = 2;
    public int wires = 0;
    public boolean active = false;

    @Override
    protected boolean canTakeLV() {
        return true;
    }

    @Override
    protected boolean canTakeMV() {
        return true;
    }

    @Override
    protected boolean canTakeHV() {
        return true;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public boolean allowEnergyToPass(ImmersiveNetHandler.Connection con) {
        return this.active;
    }

    @Override
    public boolean canConnectCable(WireType cableType, TargetingInfo target) {
        if (cableType != null && !cableType.isEnergyWire()) {
            return false;
        }
        if (this.wires >= 2) {
            return false;
        }
        return this.limitType == null || cableType == this.limitType;
    }

    @Override
    public void connectCable(WireType cableType, TargetingInfo target) {
        if (this.limitType == null) {
            this.limitType = cableType;
        }
        ++this.wires;
    }

    @Override
    public WireType getCableLimiter(TargetingInfo target) {
        return this.limitType;
    }

    @Override
    public void removeCable(ImmersiveNetHandler.Connection connection) {
        WireType type;
        WireType wireType = type = connection != null ? connection.cableType : null;
        this.wires = type == null ? 0 : --this.wires;
        if (this.wires <= 0) {
            this.limitType = null;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("facing", this.facing);
        nbt.func_74768_a("sideAttached", this.sideAttached);
        nbt.func_74768_a("wires", this.wires);
        nbt.func_74757_a("active", this.active);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.facing = nbt.func_74762_e("facing");
        this.sideAttached = nbt.func_74762_e("sideAttached");
        this.wires = nbt.func_74762_e("wires");
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public Vec3 getRaytraceOffset() {
        return Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
    }

    @Override
    public Vec3 getConnectionOffset(ImmersiveNetHandler.Connection con) {
        double h;
        int xDif;
        double r = con.cableType.getRenderDiameter() / 2.0;
        if (this.sideAttached == 0) {
            double h2 = 0.25 + r;
            if (con != null && con.start != null && con.end != null && (con.start.equals((Object)Utils.toCC(this)) && con.end != null && con.end.field_71572_b > this.field_145848_d || con.end.equals((Object)Utils.toCC(this)) && con.start != null && con.start.field_71572_b > this.field_145848_d)) {
                h2 = 0.8125 - r;
            }
            return Vec3.func_72443_a((double)(this.facing == 4 ? 0.0625 - r : (this.facing == 5 ? 0.9375 + r : 0.5)), (double)h2, (double)(this.facing == 2 ? 0.0625 - r : (this.facing == 3 ? 0.9375 + r : 0.5)));
        }
        int n = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71574_a - this.field_145851_c : (xDif = con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71574_a - this.field_145851_c : 0));
        int zDif = con == null || con.start == null || con.end == null ? 0 : (con.start.equals((Object)Utils.toCC(this)) && con.end != null ? con.end.field_71573_c - this.field_145849_e : (con.end.equals((Object)Utils.toCC(this)) && con.start != null ? con.start.field_71573_c - this.field_145849_e : 0));
        double d = h = this.sideAttached == 1 ? 0.0625 - r : 0.9375 + r;
        if (this.facing == 4 && xDif > 0 || this.facing == 5 && xDif < 0 || this.facing == 2 && zDif > 0 || this.facing == 3 && zDif < 0) {
            return Vec3.func_72443_a((double)(this.facing == 4 ? 0.6875 : (this.facing == 5 ? 0.3125 : 0.5)), (double)h, (double)(this.facing == 2 ? 0.6875 : (this.facing == 3 ? 0.3125 : 0.5)));
        }
        return Vec3.func_72443_a((double)(this.facing == 4 ? 0.25 : (this.facing == 5 ? 0.75 : 0.5)), (double)h, (double)(this.facing == 2 ? 0.25 : (this.facing == 3 ? 0.75 : 0.5)));
    }

    public void toggle() {
        this.active = !this.active;
        ImmersiveNetHandler.INSTANCE.resetCachedIndirectConnections();
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), this.active ? 1 : 0, 0);
    }

    public boolean func_145842_c(int id, int arg) {
        this.active = id == 1;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }
}

