/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFurnaceHeater
extends TileEntityIEBase
implements IEnergyReceiver {
    public EnergyStorage energyStorage = new EnergyStorage(32000, 256);
    public int[] sockets = new int[6];
    public boolean active = false;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean a = this.active;
            if (this.active) {
                this.active = false;
            }
            for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
                int energy;
                int heatEnergyRatio;
                int heatAttempt;
                int energy2;
                int heat;
                TileEntityFurnace furnace;
                boolean canHeat;
                if (!(this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ) instanceof TileEntityFurnace) || !(canHeat = this.canHeat(furnace = (TileEntityFurnace)this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ))) && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) continue;
                boolean burning = furnace.func_145950_i();
                if (furnace.field_145956_a < 200 && (heat = (energy2 = this.energyStorage.extractEnergy((heatAttempt = 4) * (heatEnergyRatio = Math.max(1, Config.getInt("heater_consumption"))), true)) / heatEnergyRatio) > 0) {
                    furnace.field_145956_a += heat;
                    this.energyStorage.extractEnergy(heat * heatEnergyRatio, false);
                    if (!burning) {
                        BlockFurnace.func_149931_a((furnace.field_145956_a > 0 ? 1 : 0) != 0, (World)this.field_145850_b, (int)furnace.field_145851_c, (int)furnace.field_145848_d, (int)furnace.field_145849_e);
                    }
                    if (!this.active) {
                        this.active = true;
                    }
                }
                if (!canHeat || furnace.field_145956_a < 200 || furnace.field_145961_j >= 199 || this.energyStorage.extractEnergy(energy = Config.getInt("heater_speedupConsumption"), false) < energy) continue;
                ++furnace.field_145961_j;
                if (this.active) continue;
                this.active = true;
            }
            if (this.active != a) {
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)IEContent.blockMetalDevice, 1, this.active ? 1 : 0);
            }
        }
    }

    public boolean canHeat(TileEntityFurnace furnace) {
        ItemStack input = furnace.func_70301_a(0);
        if (input == null) {
            return false;
        }
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(input);
        if (output == null) {
            return false;
        }
        ItemStack existingOutput = furnace.func_70301_a(2);
        if (existingOutput == null) {
            return true;
        }
        if (!existingOutput.func_77969_a(output)) {
            return false;
        }
        int stackSize = existingOutput.field_77994_a + output.field_77994_a;
        return stackSize <= furnace.func_70297_j_() && stackSize <= output.func_77976_d();
    }

    public boolean showActiveTexture() {
        return this.active || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void toggleSide(int side) {
        this.sockets[side] = this.sockets[side] == 1 ? 0 : 1;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
    }

    public boolean func_145842_c(int id, int arg) {
        if (id == 1) {
            this.active = arg == 1;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.readFromNBT(nbt);
        this.sockets = nbt.func_74759_k("sockets");
        if (this.sockets.length < 6) {
            this.sockets = new int[0];
        }
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74783_a("sockets", this.sockets);
        nbt.func_74757_a("active", this.active);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.sockets[from.ordinal()] == 1;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.sockets[from.ordinal()] == 0) {
            return 0;
        }
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }
}

