/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.ThermoelectricHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidBlock;

public class TileEntityThermoelectricGen
extends TileEntityIEBase
implements IEnergyConnection {
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (ForgeDirection fd : new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.SOUTH, ForgeDirection.EAST}) {
                if (this.field_145850_b.func_147437_c(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ) || this.field_145850_b.func_147437_c(this.field_145851_c + fd.getOpposite().offsetX, this.field_145848_d + fd.getOpposite().offsetY, this.field_145849_e + fd.getOpposite().offsetZ)) continue;
                int temp0 = this.getTemperature(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
                int temp1 = this.getTemperature(this.field_145851_c + fd.getOpposite().offsetX, this.field_145848_d + fd.getOpposite().offsetY, this.field_145849_e + fd.getOpposite().offsetZ);
                if (temp0 <= -1 || temp1 <= -1) continue;
                int diff = Math.abs(temp0 - temp1);
                int energy = (int)(Math.sqrt(diff) / 2.0 * Config.getDouble("thermoelectric_output"));
                this.outputEnergy(energy);
            }
        }
    }

    public void outputEnergy(int amount) {
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            if (!(this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ) instanceof IEnergyReceiver)) continue;
            IEnergyReceiver ier = (IEnergyReceiver)this.field_145850_b.func_147438_o(this.field_145851_c + fd.offsetX, this.field_145848_d + fd.offsetY, this.field_145849_e + fd.offsetZ);
            amount -= ier.receiveEnergy(fd.getOpposite(), amount, false);
        }
    }

    int getTemperature(int x, int y, int z) {
        Fluid f = this.getFluid(x, y, z);
        if (f != null) {
            return f.getTemperature(this.field_145850_b, x, y, z);
        }
        return ThermoelectricHandler.getTemperature(this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z));
    }

    Fluid getFluid(int x, int y, int z) {
        Fluid f = FluidRegistry.lookupFluidForBlock((Block)this.field_145850_b.func_147439_a(x, y, z));
        if (f == null && this.field_145850_b.func_147439_a(x, y, z) instanceof BlockDynamicLiquid && this.field_145850_b.func_72805_g(x, y, z) == 0) {
            if (this.field_145850_b.func_147439_a(x, y, z).func_149688_o().equals(Material.field_151586_h)) {
                f = FluidRegistry.WATER;
            } else if (this.field_145850_b.func_147439_a(x, y, z).func_149688_o().equals(Material.field_151587_i)) {
                f = FluidRegistry.LAVA;
            }
        }
        if (this.field_145850_b.func_147439_a(x, y, z) instanceof IFluidBlock && !((IFluidBlock)this.field_145850_b.func_147439_a(x, y, z)).canDrain(this.field_145850_b, x, y, z)) {
            return null;
        }
        if (this.field_145850_b.func_147439_a(x, y, z) instanceof BlockStaticLiquid && this.field_145850_b.func_72805_g(x, y, z) != 0) {
            return null;
        }
        if (f == null) {
            return null;
        }
        return f;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }
}

