/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.api;

import com.dynious.refinedrelocation.api.IAPIHandler;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingMemberHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public final class APIUtils {
    private static IAPIHandler apiHandler;

    public static void openFilteringGUI(EntityPlayer entityPlayer, World world, int x, int y, int z) {
        entityPlayer.openGui(apiHandler.getModInstance(), apiHandler.getFilteringGUIID(), world, x, y, z);
    }

    public static IFilterGUI createStandardFilter(IFilterTileGUI filterTile) {
        return apiHandler.createStandardFilter(filterTile);
    }

    public static ISortingMemberHandler createSortingMemberHandler(TileEntity owner) {
        return apiHandler.createSortingMemberHandler(owner);
    }

    public static ISortingInventoryHandler createSortingInventoryHandler(TileEntity owner) {
        return apiHandler.createSortingInventoryHandler(owner);
    }

    public static void registerRelocatorModule(String identifier, Class<? extends IRelocatorModule> clazz) throws IllegalArgumentException {
        apiHandler.registerRelocatorModule(identifier, clazz);
    }

    public static void openRelocatorModuleGUI(IItemRelocator relocator, EntityPlayer player, int side) {
        apiHandler.openRelocatorModuleGUI(relocator, player, side);
    }

    public static void registerToolboxClazz(Class clazz) {
        apiHandler.registerToolboxClazz(clazz);
    }

    static {
        try {
            Class<?> c = Class.forName("com.dynious.refinedrelocation.APIHandler");
            apiHandler = (IAPIHandler)c.getField("instance").get(c);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

