/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class WoodType {
    String textureName;
    String modId;
    String itemId;
    int meta;
    ResourceLocation[] textures;

    public WoodType(String name, String modId, String itemId, int meta) {
        this.textureName = name;
        this.modId = modId;
        this.itemId = itemId;
        this.meta = meta;
        this.textures = new ResourceLocation[4];
        this.textures[0] = new ResourceLocation("enhancedinventories", "textures/uvs/wood/64x64/" + modId + "/" + this.textureName.toLowerCase() + ".png");
        this.textures[1] = new ResourceLocation("enhancedinventories", "textures/uvs/wood/128x128/" + modId + "/" + this.textureName.toLowerCase() + ".png");
        this.textures[2] = new ResourceLocation("enhancedinventories", "textures/uvs/wood/chestSmall/" + modId + "/" + this.textureName.toLowerCase() + ".png");
        this.textures[3] = new ResourceLocation("enhancedinventories", "textures/uvs/wood/chestLarge/" + modId + "/" + this.textureName.toLowerCase() + ".png");
    }

    public String getModID() {
        return this.modId;
    }

    public String getItemID() {
        return this.itemId;
    }

    public int getMetaData() {
        return this.meta;
    }

    public String name() {
        return this.getPlanksStack().func_82833_r();
    }

    public String id() {
        return "wood:" + this.modId + ":" + this.itemId + ":" + this.meta;
    }

    public boolean matches(ItemStack target) {
        ItemStack woodStack = this.getPlanksStack();
        if (woodStack == null || target == null) {
            return false;
        }
        return woodStack.func_77973_b() == target.func_77973_b() && woodStack.func_77960_j() == target.func_77960_j();
    }

    public ItemStack getPlanksStack() {
        ItemStack ret = GameRegistry.findItemStack((String)this.modId, (String)this.itemId, (int)1);
        if (ret == null) {
            return null;
        }
        ret = new ItemStack(ret.func_77973_b(), 1, this.meta);
        return ret;
    }

    public ResourceLocation getTexture(int index) {
        return this.textures[index];
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List results, boolean bool) {
        results.add(this.getPlanksStack().func_82833_r());
    }
}

