/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import yuuto.enhancedinventories.EInventoryMaterial;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;
import yuuto.enhancedinventories.WoolUpgradeHelper;
import yuuto.enhancedinventories.block.BlockConnectiveInventory;
import yuuto.enhancedinventories.compat.refinedrelocation.SortingUpgradeHelper;
import yuuto.enhancedinventories.compat.refinedrelocation.TileImprovedSortingChest;
import yuuto.enhancedinventories.item.ItemSizeUpgrade;
import yuuto.enhancedinventories.tile.TileImprovedChest;

public class BlockImprovedChest
extends BlockConnectiveInventory {
    private final Random random = new Random();

    public BlockImprovedChest() {
        super(Material.field_151575_d, EnhancedInventories.tab, "EnhancedInventories", "improvedChest", ".Stone", ".Iron", ".Gold", ".Diamond", ".Emerald", ".Obsidian", ".Copper", ".Tin", ".Silver", ".Bronze", ".Steel", ".Platinum", ".Alumite", ".Cobalt", ".Ardite", ".Manyullyn");
        this.func_149711_c(2.1f);
    }

    public BlockImprovedChest(String name) {
        super(Material.field_151575_d, EnhancedInventories.tab, "EnhancedInventories", name, ".Stone", ".Iron", ".Gold", ".Diamond", ".Emerald", ".Obsidian", ".Copper", ".Tin", ".Silver", ".Bronze", ".Steel", ".Platinum", ".Alumite", ".Cobalt", ".Ardite", ".Manyullyn");
        this.func_149711_c(2.1f);
        this.func_149752_b(10.0f);
    }

    @Override
    public int func_149645_b() {
        return 22;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        ItemStack held = player.func_70694_bm();
        if (!EnhancedInventories.refinedRelocation || held == null) {
            return super.func_149727_a(world, x, y, z, player, side, p_149727_7_, p_149727_8_, p_149727_9_);
        }
        if (held.func_77973_b() == SortingUpgradeHelper.getUpgradeItem()) {
            if (world.field_72995_K) {
                return true;
            }
            TileImprovedChest original = (TileImprovedChest)world.func_147438_o(x, y, z);
            if (!original.canUpgrade(held)) {
                return false;
            }
            if (!SortingUpgradeHelper.hasUpgradeMaterials(original, player)) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Requires 2 " + original.getType().getMaterial()));
                return false;
            }
            try {
                TileImprovedSortingChest newChest = (TileImprovedSortingChest)original.getUpgradeTile(held);
                if (newChest == null || newChest == original || !ItemSizeUpgrade.canUpgrade(original, newChest, world, x, y, z)) {
                    return false;
                }
                newChest.setContents(original.getContents(), true);
                world.func_147468_f(x, y, z);
                world.func_147465_d(x, y, z, (Block)EnhancedInventories.improvedSortingChest, original.getType().ordinal(), 3);
                world.func_147455_a(x, y, z, (TileEntity)newChest);
                world.func_72921_c(x, y, z, newChest.getType().ordinal(), 3);
                newChest.checkConnections();
                newChest.markDirty(true);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                    SortingUpgradeHelper.removeUpgradeMaterials(newChest, player);
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (WoolUpgradeHelper.getDyeId(held) >= 0) {
            if (world.field_72995_K) {
                return true;
            }
            TileImprovedChest original = (TileImprovedChest)world.func_147438_o(x, y, z);
            if (!original.canUpgrade(held)) {
                return false;
            }
            try {
                TileImprovedChest newChest = original.getUpgradeTile(held);
                if (newChest == null || newChest == original || !ItemSizeUpgrade.canUpgrade(original, newChest, world, x, y, z)) {
                    return false;
                }
                newChest.setContents(original.getContents(), true);
                original.func_145843_s();
                world.func_147455_a(x, y, z, (TileEntity)newChest);
                world.func_72921_c(x, y, z, world.func_72805_g(x, y, z), 3);
                original.func_145843_s();
                newChest.disconnect();
                newChest.checkConnections();
                newChest.markDirty(true);
                if (!player.field_71075_bZ.field_75098_d) {
                    --held.field_77994_a;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return super.func_149727_a(world, x, y, z, player, side, p_149727_7_, p_149727_8_, p_149727_9_);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int l;
        super.func_149689_a(world, x, y, z, player, stack);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileImprovedChest)) {
            return;
        }
        TileImprovedChest chest = (TileImprovedChest)tile;
        if (stack.func_77942_o()) {
            chest.woodType = stack.func_77978_p().func_74779_i("woodType");
            chest.woolType = stack.func_77978_p().func_74762_e("wool");
            chest.hopper = stack.func_77978_p().func_74767_n("hopper");
            chest.alt = stack.func_77978_p().func_74767_n("alt");
            chest.redstone = stack.func_77978_p().func_74767_n("redstone");
        }
        if ((l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0) {
            chest.setOrientation(ForgeDirection.getOrientation((int)2));
        } else if (l == 1) {
            chest.setOrientation(ForgeDirection.getOrientation((int)5));
        } else if (l == 2) {
            chest.setOrientation(ForgeDirection.getOrientation((int)3));
        } else if (l == 3) {
            chest.setOrientation(ForgeDirection.getOrientation((int)4));
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileImprovedChest(EInventoryMaterial.values()[meta]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List subItems) {
        Random rand = new Random();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("woodType", WoodTypes.getWoodTypes().get(rand.nextInt(WoodTypes.getWoodTypes().size())).id());
        nbt.func_74774_a("wool", (byte)rand.nextInt(16));
        for (int ix = 0; ix < this.subNames.length; ++ix) {
            ItemStack stack = new ItemStack((Block)this, 1, ix);
            stack.func_77982_d((NBTTagCompound)nbt.func_74737_b());
            subItems.add(stack);
        }
    }

    public void func_149636_a(World p_149636_1_, EntityPlayer player, int x, int y, int z, int p_149636_6_) {
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        player.func_71064_a(StatList.field_75934_C[BlockImprovedChest.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        this.harvesters.set(player);
        int i1 = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
        this.func_149697_b(world, x, y, z, meta, i1);
        this.harvesters.set(null);
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileImprovedChest) {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74778_a("woodType", ((TileImprovedChest)tile).woodType);
                stack.func_77978_p().func_74774_a("wool", (byte)((TileImprovedChest)tile).woolType);
                stack.func_77978_p().func_74757_a("alt", ((TileImprovedChest)tile).alt);
                if (((TileImprovedChest)tile).hopper) {
                    this.dropItem(new ItemStack((Item)EnhancedInventories.functionUpgrade, 1, 1), world, x, y, z);
                }
                if (((TileImprovedChest)tile).redstone) {
                    this.dropItem(new ItemStack((Item)EnhancedInventories.functionUpgrade, 1, 2), world, x, y, z);
                }
            }
            this.dropItem(stack, world, x, y, z);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block p_149749_5_, int meta) {
        TileImprovedChest tileentitychest = (TileImprovedChest)world.func_147438_o(x, y, z);
        if (tileentitychest.getPartner() != null) {
            tileentitychest.getPartner().disconnect();
            tileentitychest.disconnect();
        }
        if (tileentitychest != null) {
            for (int i1 = 0; i1 < tileentitychest.func_70302_i_(); ++i1) {
                ItemStack itemstack = tileentitychest.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.random.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.random.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.random.nextGaussian() * f3;
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, p_149749_5_);
        }
        super.func_149749_a(world, x, y, z, p_149749_5_, meta);
    }

    protected ItemStack func_149644_j(int meta) {
        int j = meta;
        Item item = Item.func_150898_a((Block)this);
        ItemStack ret = new ItemStack(item, 1, j);
        ret.func_77982_d(new NBTTagCompound());
        ret.func_77978_p().func_74778_a("woodType", "wood:minecraft:planks:0");
        ret.func_77978_p().func_74774_a("wool", (byte)0);
        ret.func_77978_p().func_74757_a("alt", false);
        return ret;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        ItemStack ret = new ItemStack(item, 1, world.func_72805_g(x, y, z));
        TileEntity tile = world.func_147438_o(x, y, z);
        ret.func_77982_d(new NBTTagCompound());
        if (tile != null && tile instanceof TileImprovedChest) {
            ret.func_77978_p().func_74778_a("woodType", ((TileImprovedChest)tile).woodType);
            ret.func_77978_p().func_74774_a("wool", (byte)((TileImprovedChest)tile).woolType);
            ret.func_77978_p().func_74757_a("alt", ((TileImprovedChest)tile).alt);
            return ret;
        }
        ret.func_77978_p().func_74778_a("woodType", "wood:minecraft:planks:0");
        ret.func_77978_p().func_74774_a("wool", (byte)0);
        ret.func_77978_p().func_74757_a("alt", false);
        return ret;
    }

    public boolean canPlaceBlockAt(ItemStack itemBlock, World world, int x, int y, int z) {
        ArrayList<ForgeDirection> dirs = TileImprovedChest.conDirs;
        int chests = 0;
        for (ForgeDirection dir : dirs) {
            TileImprovedChest chest;
            TileEntity tile = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
            if (tile == null || !(tile instanceof TileImprovedChest) || !(chest = (TileImprovedChest)tile).isValidForConnection(itemBlock)) continue;
            if (chest.getPartner() != null) {
                return false;
            }
            ++chests;
        }
        return chests <= true;
    }

    public void func_149719_a(IBlockAccess p_149719_1_, int p_149719_2_, int p_149719_3_, int p_149719_4_) {
        TileImprovedChest tile = (TileImprovedChest)p_149719_1_.func_147438_o(p_149719_2_, p_149719_3_, p_149719_4_);
        if (tile.getPartner() == null) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
            return;
        }
        switch (tile.getPartnerDir()) {
            case NORTH: {
                this.func_149676_a(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9375f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9375f);
                break;
            }
            default: {
                this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
            }
        }
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.func_72805_g(x, y, z);
        int tier = EInventoryMaterial.values()[meta].getTier();
        switch (tier) {
            case 4: {
                return 2000.0f;
            }
            case 5: {
                return 2000.0f;
            }
        }
        return this.func_149638_a(par1Entity);
    }
}

