/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.client;

import java.awt.Color;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.model.ModelLargeChest;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import yuuto.enhancedinventories.ColorHelper;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoodTypes;
import yuuto.enhancedinventories.tile.TileImprovedChest;

public class RendererImprovedChest
extends TileEntitySpecialRenderer {
    private static ModelChest modelSingleChest = new ModelChest();
    private static ModelChest modelDoubleChest = new ModelLargeChest();
    static ResourceLocation singleChestFrame = new ResourceLocation("enhancedinventories", "textures/uvs/normalChestFrame.png");
    static ResourceLocation singleChestWool = new ResourceLocation("enhancedinventories", "textures/uvs/normalChestWool.png");
    static ResourceLocation singleRefinedLocation;
    static ResourceLocation doubleChestFrame;
    static ResourceLocation doubleChestWool;
    static ResourceLocation doubleRefinedLocation;

    public RendererImprovedChest() {
        if (EnhancedInventories.refinedRelocation) {
            singleRefinedLocation = new ResourceLocation("enhancedinventories", "textures/uvs/refinedRelocation/normalChest.png");
            doubleRefinedLocation = new ResourceLocation("enhancedinventories", "textures/uvs/refinedRelocation/doubleChest.png");
        }
    }

    public void func_147500_a(TileEntity tile, double x, double y, double z, float f) {
        if (!(tile instanceof TileImprovedChest)) {
            return;
        }
        TileImprovedChest chest = (TileImprovedChest)tile;
        if (chest.getPartner() == null) {
            this.renderSingle((TileImprovedChest)tile, x, y, z, f, 0);
            this.renderSingle((TileImprovedChest)tile, x, y, z, f, 1);
            this.renderSingle((TileImprovedChest)tile, x, y, z, f, 2);
            if (((TileImprovedChest)tile).sortingChest) {
                this.renderSingle((TileImprovedChest)tile, x, y, z, f, 3);
            }
        } else if (!chest.getTopSides().contains(chest.getPartnerDir())) {
            this.renderDouble((TileImprovedChest)tile, x, y, z, f, 0);
            this.renderDouble((TileImprovedChest)tile, x, y, z, f, 1);
            this.renderDouble((TileImprovedChest)tile, x, y, z, f, 2);
            if (((TileImprovedChest)tile).sortingChest) {
                this.renderDouble((TileImprovedChest)tile, x, y, z, f, 3);
            }
        }
    }

    void renderSingle(TileImprovedChest chest, double x, double y, double z, float f, int pass) {
        int i = chest.getOrientation().ordinal();
        ModelChest modelchest = modelSingleChest;
        GL11.glPushMatrix();
        switch (pass) {
            case 0: {
                this.func_147499_a(WoodTypes.getWoodType(chest.woodType).getTexture(2));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 1: {
                Color c = ColorHelper.WOOL_COLORS[chest.woolType];
                GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
                this.func_147499_a(singleChestWool);
                break;
            }
            case 2: {
                if (chest.getType().hasTexture()) {
                    this.func_147499_a(chest.getType().getTexture(0));
                    break;
                }
                GL11.glColor4f((float)chest.getType().r(), (float)chest.getType().g(), (float)chest.getType().b(), (float)1.0f);
                this.func_147499_a(singleChestFrame);
                break;
            }
            case 3: {
                this.func_147499_a(singleRefinedLocation);
            }
        }
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int short1 = 0;
        if (i == 2) {
            short1 = 180;
        }
        if (i == 3) {
            short1 = 0;
        }
        if (i == 4) {
            short1 = 90;
        }
        if (i == 5) {
            short1 = -90;
        }
        GL11.glRotatef((float)short1, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f1 = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * f;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        modelchest.field_78234_a.field_78795_f = -(f1 * (float)Math.PI / 2.0f);
        modelchest.func_78231_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    void renderDouble(TileImprovedChest chest, double x, double y, double z, float f, int pass) {
        ForgeDirection d;
        int i = chest.getOrientation().ordinal();
        ModelChest modelchest = modelDoubleChest;
        GL11.glPushMatrix();
        switch (pass) {
            case 0: {
                this.func_147499_a(WoodTypes.getWoodType(chest.woodType).getTexture(3));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
            case 1: {
                Color c = ColorHelper.WOOL_COLORS[chest.woolType];
                GL11.glColor4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
                this.func_147499_a(doubleChestWool);
                break;
            }
            case 2: {
                if (chest.getType().hasTexture()) {
                    this.func_147499_a(chest.getType().getTexture(1));
                    break;
                }
                GL11.glColor4f((float)chest.getType().r(), (float)chest.getType().g(), (float)chest.getType().b(), (float)1.0f);
                this.func_147499_a(doubleChestFrame);
                break;
            }
            case 3: {
                this.func_147499_a(doubleRefinedLocation);
            }
        }
        GL11.glEnable((int)32826);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        int short1 = 0;
        if (i == 2) {
            short1 = 180;
        }
        if (i == 3) {
            short1 = 0;
        }
        if (i == 4) {
            short1 = 90;
        }
        if (i == 5) {
            short1 = -90;
        }
        if (i == 2 && chest.getPartnerDir() == ForgeDirection.EAST) {
            d = chest.getPartnerDir();
            GL11.glTranslatef((float)d.offsetX, (float)d.offsetY, (float)d.offsetZ);
        }
        if (i == 3 && chest.getPartnerDir() == ForgeDirection.WEST) {
            d = chest.getPartnerDir();
            GL11.glTranslatef((float)d.offsetX, (float)d.offsetY, (float)d.offsetZ);
        }
        if (i == 5 && chest.getPartnerDir() == ForgeDirection.SOUTH) {
            d = chest.getPartnerDir();
            GL11.glTranslatef((float)(-d.offsetX), (float)(-d.offsetY), (float)(-d.offsetZ));
        }
        if (i == 4 && chest.getPartnerDir() == ForgeDirection.NORTH) {
            d = chest.getPartnerDir();
            GL11.glTranslatef((float)(-d.offsetX), (float)(-d.offsetY), (float)(-d.offsetZ));
        }
        GL11.glRotatef((float)short1, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float f1 = chest.prevLidAngle + (chest.lidAngle - chest.prevLidAngle) * f;
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        modelchest.field_78234_a.field_78795_f = -(f1 * (float)Math.PI / 2.0f);
        modelchest.func_78231_a();
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    static {
        doubleChestFrame = new ResourceLocation("enhancedinventories", "textures/uvs/doubleChestFrame.png");
        doubleChestWool = new ResourceLocation("enhancedinventories", "textures/uvs/doubleChestWool.png");
    }
}

