/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.compat.refinedrelocation;

import com.dynious.refinedrelocation.api.APIUtils;
import com.dynious.refinedrelocation.api.filter.IFilterGUI;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.api.tileentity.ISortingInventory;
import com.dynious.refinedrelocation.api.tileentity.handlers.ISortingInventoryHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import yuuto.enhancedinventories.EInventoryMaterial;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.WoolUpgradeHelper;
import yuuto.enhancedinventories.compat.refinedrelocation.SortingUpgradeHelper;
import yuuto.enhancedinventories.tile.TileImprovedChest;

public class TileImprovedSortingChest
extends TileImprovedChest
implements ISortingInventory,
IFilterTileGUI {
    public ISortingInventoryHandler sortingInventoryHandler = APIUtils.createSortingInventoryHandler(this);
    public IFilterGUI filter = APIUtils.createStandardFilter(this);
    public ISortingInventory.Priority priority = ISortingInventory.Priority.NORMAL;

    public TileImprovedSortingChest() {
        this.sortingChest = true;
    }

    public TileImprovedSortingChest(EInventoryMaterial type) {
        super(type);
        this.sortingChest = true;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sortingInventoryHandler.onTileAdded();
    }

    @Override
    public void func_145843_s() {
        this.sortingInventoryHandler.onTileRemoved();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.sortingInventoryHandler.onTileRemoved();
        super.onChunkUnload();
    }

    @Override
    public IFilterGUI getFilter() {
        return this.filter;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void onFilterChanged() {
        this.func_70296_d();
    }

    @Override
    public ISortingInventoryHandler getHandler() {
        return this.sortingInventoryHandler;
    }

    @Override
    public final boolean putStackInSlot(ItemStack itemstack, int slot) {
        boolean flag = false;
        int i = slot;
        if (slot < 0 || slot > this.func_70302_i_()) {
            return false;
        }
        if (this.partnerTile == null) {
            flag = true;
        } else if (this.getTopSides().contains(this.partnerDir)) {
            if (i < this.type.size()) {
                flag = true;
            } else {
                i -= this.type.size();
            }
        } else if (i >= this.type.size()) {
            flag = true;
            i -= this.type.size();
        }
        if (flag) {
            this.chestContents[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        } else {
            this.partnerTile.getContents()[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.partnerTile.func_70297_j_()) {
                itemstack.field_77994_a = this.partnerTile.func_70297_j_();
            }
        }
        this.func_70296_d();
        return true;
    }

    @Override
    public ItemStack putInInventory(ItemStack itemStack, boolean simulate) {
        int emptySlot = -1;
        for (int slot = 0; slot < this.func_70302_i_() && itemStack != null && itemStack.field_77994_a > 0; ++slot) {
            int max;
            if (!this.func_94041_b(slot, itemStack)) continue;
            ItemStack itemstack1 = this.func_70301_a(slot);
            if (itemstack1 == null) {
                if (simulate) {
                    return null;
                }
                if (emptySlot != -1) continue;
                emptySlot = slot;
                continue;
            }
            if (!TileImprovedSortingChest.areItemStacksEqual(itemstack1, itemStack) || (max = Math.min(itemStack.func_77976_d(), this.func_70297_j_())) <= itemstack1.field_77994_a) continue;
            int l = Math.min(itemStack.field_77994_a, max - itemstack1.field_77994_a);
            itemStack.field_77994_a -= l;
            if (simulate) continue;
            itemstack1.field_77994_a += l;
            this.func_70296_d();
        }
        if (itemStack != null && itemStack.field_77994_a != 0 && emptySlot != -1) {
            if (this.putStackInSlot(itemStack, emptySlot)) {
                itemStack = null;
            }
            this.func_70296_d();
        }
        return itemStack;
    }

    @Override
    public ISortingInventory.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(ISortingInventory.Priority priority) {
        this.priority = priority;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.getHandler().setInventorySlotContents(i, itemstack);
    }

    public static boolean areItemStacksEqual(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1 == null && itemStack2 == null || itemStack1 != null && itemStack2 != null && itemStack1.func_77973_b() == itemStack2.func_77973_b() && itemStack1.func_77960_j() == itemStack2.func_77960_j() && (itemStack1.field_77990_d != null || itemStack2.field_77990_d == null) && (itemStack1.field_77990_d == null || itemStack1.field_77990_d.equals((Object)itemStack2.field_77990_d));
    }

    @Override
    public TileImprovedSortingChest getUpgradeTile(ItemStack stack) {
        if (stack.func_77973_b() == EnhancedInventories.functionUpgrade) {
            TileImprovedSortingChest ret = new TileImprovedSortingChest(this.getType());
            ret.woodType = this.woodType;
            ret.woolType = this.woolType;
            ret.alt = this.alt;
            ret.hopper = this.hopper;
            ret.redstone = this.redstone;
            ret.setOrientation(this.orientation);
            ret.setPriority(this.priority);
            ret.filter = this.filter;
            switch (stack.func_77960_j()) {
                case 1: {
                    if (ret.hopper) {
                        return this;
                    }
                    ret.hopper = true;
                    break;
                }
                case 2: {
                    if (ret.redstone) {
                        return this;
                    }
                    ret.redstone = true;
                    break;
                }
                default: {
                    return this;
                }
            }
            return ret;
        }
        int woolId = WoolUpgradeHelper.getDyeId(stack);
        if (woolId >= 0) {
            TileImprovedSortingChest ret = new TileImprovedSortingChest(this.getType());
            ret.woodType = this.woodType;
            ret.woolType = this.woolType;
            ret.alt = this.alt;
            ret.hopper = this.hopper;
            ret.redstone = this.redstone;
            ret.setOrientation(this.orientation);
            ret.woolType = WoolUpgradeHelper.getCollorValue(woolId);
            return ret;
        }
        return this;
    }

    @Override
    public boolean canUpgrade(ItemStack stack) {
        if (stack.func_77973_b() == SortingUpgradeHelper.getUpgradeItem()) {
            return false;
        }
        if (stack.func_77973_b() == EnhancedInventories.sizeUpgrade) {
            return false;
        }
        return super.canUpgrade(stack);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.filter.readFromNBT(compound);
        if (compound.func_74764_b("priority")) {
            this.setPriority(ISortingInventory.Priority.values()[compound.func_74771_c("priority")]);
        } else {
            this.setPriority(this.filter.isBlacklisting() ? ISortingInventory.Priority.LOW : ISortingInventory.Priority.NORMAL);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.filter.writeToNBT(compound);
        compound.func_74774_a("priority", (byte)this.priority.ordinal());
    }
}

