/*
 * Decompiled with CFR 0.152.
 */
package yuuto.enhancedinventories.tile;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import yuuto.enhancedinventories.EInventoryMaterial;
import yuuto.enhancedinventories.EnhancedInventories;
import yuuto.enhancedinventories.gui.IConnectedContainer;
import yuuto.yuutolib.block.tile.TileRotatable;

public abstract class TileConnectiveInventory
extends TileRotatable
implements IInventory {
    protected int ticksSinceSync = -1;
    public float prevLidAngle;
    public float lidAngle;
    protected int numUsingPlayers;
    protected ItemStack[] chestContents;
    protected EInventoryMaterial type;
    protected ForgeDirection partnerDir = ForgeDirection.UNKNOWN;
    protected TileConnectiveInventory partnerTile;
    boolean initialized = false;
    boolean needsConnectionUpdate = false;
    boolean disconnected = false;
    public boolean redstone;

    public TileConnectiveInventory() {
        this(EInventoryMaterial.Stone);
    }

    public TileConnectiveInventory(EInventoryMaterial type) {
        this.type = type;
        this.chestContents = new ItemStack[this.func_70302_i_()];
    }

    public TileConnectiveInventory getPartner() {
        return this.partnerTile;
    }

    public ForgeDirection getPartnerDir() {
        return this.partnerDir;
    }

    public void connectTo(TileConnectiveInventory tile, ForgeDirection from) {
        if (!this.initialized) {
            return;
        }
        if (this.partnerTile != null && !this.partnerTile.func_145837_r()) {
            return;
        }
        this.partnerTile = tile;
        this.partnerDir = from;
        this.orientation = this.partnerTile.orientation;
    }

    public void disconnect() {
        this.partnerTile = null;
        this.partnerDir = ForgeDirection.UNKNOWN;
        if (!this.field_145850_b.field_72995_K) {
            this.disconnected = true;
            this.func_70296_d();
        }
    }

    public abstract boolean isValidForConnection(ItemStack var1);

    public abstract boolean isValidForConnection(TileConnectiveInventory var1);

    public boolean canConnectTo(TileConnectiveInventory tile, ForgeDirection from) {
        if (!this.initialized) {
            return false;
        }
        if (this.partnerTile != null && !this.partnerTile.func_145837_r()) {
            return false;
        }
        if (!this.isValidForConnection(tile)) {
            return false;
        }
        return this.getValidConnectionSides().contains(from);
    }

    public abstract List<ForgeDirection> getValidConnectionSides();

    public abstract List<ForgeDirection> getTopSides();

    public ItemStack[] getContents() {
        return this.chestContents;
    }

    public int func_70302_i_() {
        if (this.partnerTile == null) {
            return this.type.size();
        }
        return this.type.doubleSize();
    }

    public String func_145825_b() {
        return this.type.toString();
    }

    public EInventoryMaterial getType() {
        return this.type;
    }

    public ItemStack func_70301_a(int i) {
        if (this.partnerTile == null) {
            return this.chestContents[i];
        }
        if (this.getTopSides().contains(this.partnerDir)) {
            return i < this.type.size() ? this.chestContents[i] : this.partnerTile.getContents()[i - this.type.size()];
        }
        return i < this.type.size() ? this.partnerTile.getContents()[i] : this.chestContents[i - this.type.size()];
    }

    public ItemStack func_70298_a(int slot, int j) {
        boolean flag = false;
        int i = slot;
        if (this.partnerTile == null) {
            flag = true;
        } else if (this.getTopSides().contains(this.partnerDir)) {
            if (i < this.type.size()) {
                flag = true;
            } else {
                i -= this.type.size();
            }
        } else if (i >= this.type.size()) {
            flag = true;
            i -= this.type.size();
        }
        if (flag) {
            if (this.chestContents[i] != null) {
                if (this.chestContents[i].field_77994_a <= j) {
                    ItemStack itemstack = this.chestContents[i];
                    this.chestContents[i] = null;
                    this.func_70296_d();
                    return itemstack;
                }
                ItemStack itemstack1 = this.chestContents[i].func_77979_a(j);
                if (this.chestContents[i].field_77994_a == 0) {
                    this.chestContents[i] = null;
                }
                this.func_70296_d();
                return itemstack1;
            }
            return null;
        }
        ItemStack[] contents = this.partnerTile.getContents();
        if (contents[i] != null) {
            if (contents[i].field_77994_a <= j) {
                ItemStack itemstack = contents[i];
                contents[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = contents[i].func_77979_a(j);
            if (contents[i].field_77994_a == 0) {
                contents[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        boolean flag = false;
        int i = slot;
        if (this.partnerTile == null) {
            flag = true;
        } else if (this.getTopSides().contains(this.partnerDir)) {
            if (i < this.type.size()) {
                flag = true;
            } else {
                i -= this.type.size();
            }
        } else if (i >= this.type.size()) {
            flag = true;
            i -= this.type.size();
        }
        if (flag) {
            this.chestContents[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        } else {
            this.partnerTile.getContents()[i] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.partnerTile.func_70297_j_()) {
                itemstack.field_77994_a = this.partnerTile.func_70297_j_();
            }
        }
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.type = EInventoryMaterial.values()[nbttagcompound.func_74762_e("MatType")];
        this.redstone = nbttagcompound.func_74767_n("redstone");
        if (this.chestContents.length != this.func_70302_i_()) {
            this.chestContents = new ItemStack[this.func_70302_i_()];
        }
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.chestContents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.chestContents.length) continue;
            this.chestContents[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.chestContents.length; ++i) {
            if (this.chestContents[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.chestContents[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
        nbttagcompound.func_74768_a("MatType", this.type.ordinal());
        nbttagcompound.func_74757_a("redstone", this.redstone);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        if (this.partnerTile == null) {
            return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0 || entityplayer.func_70092_e((double)this.partnerTile.field_145851_c + 0.5, (double)this.partnerTile.field_145848_d + 0.5, (double)this.partnerTile.field_145849_e + 0.5) <= 64.0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialized && !this.func_145837_r()) {
            this.initialize();
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticksSinceSync + this.field_145851_c + this.field_145848_d + this.field_145849_e) % 200 == 0) {
            this.numUsingPlayers = 0;
            float var1 = 5.0f;
            List var2 = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - var1), (double)((float)this.field_145848_d - var1), (double)((float)this.field_145849_e - var1), (double)((float)(this.field_145851_c + 1) + var1), (double)((float)(this.field_145848_d + 1) + var1), (double)((float)(this.field_145849_e + 1) + var1)));
            for (EntityPlayer var4 : var2) {
                if (!(var4.field_71070_bA instanceof IConnectedContainer)) continue;
                ++this.numUsingPlayers;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 3, this.numUsingPlayers << 3 & 0xF8 | this.orientation.ordinal() & 7);
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float f = 0.1f;
        if (this.getTotalUsingPlayers() > 0 && this.lidAngle == 0.0f && (this.partnerTile == null || this.getTopSides().contains(this.partnerDir))) {
            double d = (double)this.field_145851_c + 0.5;
            double d1 = (double)this.field_145849_e + 0.5;
            this.field_145850_b.func_72908_a(d, (double)this.field_145848_d + 0.5, d1, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.getTotalUsingPlayers() == 0 && this.lidAngle > 0.0f || this.getTotalUsingPlayers() > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.getTotalUsingPlayers() > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2 && (this.partnerTile == null || this.getTopSides().contains(this.partnerDir))) {
                double d2 = (double)this.field_145851_c + 0.5;
                double d3 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d2, (double)this.field_145848_d + 0.5, d3, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 1) {
            this.numUsingPlayers = j;
        } else if (i == 2) {
            this.orientation = ForgeDirection.getOrientation((int)j);
        } else if (i == 3) {
            this.orientation = ForgeDirection.getOrientation((int)(j & 7));
            this.numUsingPlayers = (j & 0xF8) >> 3;
        }
        return true;
    }

    public void func_70295_k_() {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void func_70305_f() {
        if (this.field_145850_b == null) {
            return;
        }
        --this.numUsingPlayers;
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public ItemStack func_70304_b(int slot) {
        boolean flag = false;
        int i = slot;
        if (this.partnerTile == null) {
            flag = true;
        } else if (this.getTopSides().contains(this.partnerDir)) {
            if (i < this.type.size()) {
                flag = true;
            } else {
                i -= this.type.size();
            }
        } else if (i >= this.type.size()) {
            flag = true;
            i -= this.type.size();
        }
        if (flag) {
            if (this.chestContents[i] != null) {
                ItemStack var2 = this.chestContents[i];
                this.chestContents[i] = null;
                return var2;
            }
            return null;
        }
        if (this.partnerTile.getContents()[i] != null) {
            ItemStack var2 = this.partnerTile.getContents()[i];
            this.partnerTile.getContents()[i] = null;
            return var2;
        }
        return null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void initialize() {
        this.initialized = true;
        this.checkConnections();
    }

    public void checkConnections() {
        for (ForgeDirection dir : this.getValidConnectionSides()) {
            TileConnectiveInventory inv;
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile == null || !(tile instanceof TileConnectiveInventory) || !(inv = (TileConnectiveInventory)tile).isValidForConnection(this) || !inv.canConnectTo(this, dir.getOpposite()) || !this.canConnectTo(inv, dir)) continue;
            if (this.orientation == dir || this.orientation == dir.getOpposite()) {
                for (ForgeDirection dir2 : this.getValidConnectionSides()) {
                    if (dir2 == dir || dir2 == dir.getOpposite()) continue;
                    this.setOrientation(dir2);
                }
            }
            inv.connectTo(this, dir.getOpposite());
            this.connectTo(inv, dir);
            break;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.partnerTile != null) {
            this.partnerTile.disconnect();
        }
        this.disconnect();
    }

    public int getUsingPlayers() {
        return this.numUsingPlayers;
    }

    public int getTotalUsingPlayers() {
        if (this.partnerTile == null) {
            return this.numUsingPlayers;
        }
        return this.numUsingPlayers + this.partnerTile.getUsingPlayers();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void markDirty(boolean connection) {
        this.needsConnectionUpdate = true;
        this.func_70296_d();
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        tagCompound.func_74776_a("pkt.prevLidAngle", this.prevLidAngle);
        tagCompound.func_74776_a("pkt.lidAngle", this.lidAngle);
        tagCompound.func_74757_a("pkt.needConUpdate", this.needsConnectionUpdate);
        tagCompound.func_74757_a("pkt.disconnected", this.disconnected);
        this.needsConnectionUpdate = false;
        this.disconnected = false;
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        NBTTagCompound nbt = pkt.func_148857_g();
        this.func_145839_a(nbt);
        this.prevLidAngle = nbt.func_74760_g("pkt.prevLidAngle");
        this.lidAngle = nbt.func_74760_g("pkt.lidAngle");
        if (nbt.func_74767_n("pkt.disconnected")) {
            this.disconnect();
        }
        if (nbt.func_74767_n("pkt.needConUpdate")) {
            this.checkConnections();
        }
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean canUpgrade(ItemStack stack) {
        if (this.getTotalUsingPlayers() > 0) {
            return false;
        }
        if (stack.func_77973_b() == EnhancedInventories.sizeUpgrade) {
            return this.type != EInventoryMaterial.Obsidian && EInventoryMaterial.values()[stack.func_77960_j() + 1].getTier() == this.getType().getTier() + 1;
        }
        if (stack.func_77973_b() == EnhancedInventories.functionUpgrade && stack.func_77960_j() == 2) {
            return !this.redstone;
        }
        return false;
    }

    public abstract TileConnectiveInventory getUpgradeTile(ItemStack var1);

    public void setContents(ItemStack[] origin, boolean removeOld) {
        for (int i = 0; i < origin.length && i <= this.chestContents.length; ++i) {
            this.chestContents[i] = origin[i];
            if (!removeOld) continue;
            origin[i] = null;
        }
    }
}

