/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches;

import com.chaosthedude.realistictorches.blocks.BlockRegistry;
import com.chaosthedude.realistictorches.handlers.ConfigHandler;
import com.chaosthedude.realistictorches.handlers.MovingLightHandler;
import com.chaosthedude.realistictorches.handlers.TorchDropHandler;
import com.chaosthedude.realistictorches.items.ItemRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="RealisticTorches", name="Realistic Torches", version="1.2.1", acceptedMinecraftVersions="[1.7.10]")
public class RealisticTorches {
    public static final String ID = "RealisticTorches";
    public static final String NAME = "Realistic Torches";
    public static final String VERSION = "1.2.1";
    public static final Logger logger = LogManager.getLogger((String)"RealisticTorches");

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        BlockRegistry.mainRegistry();
        ItemRegistry.mainRegistry();
        ConfigHandler.loadConfig(event.getSuggestedConfigurationFile());
        logger.info("Torch burnout rate: " + ConfigHandler.torchBurnout + " ticks (" + (float)(ConfigHandler.torchBurnout / 1200) + " minutes)");
        if (ConfigHandler.handheldLightEnabled) {
            logger.info("Handheld light sources are enabled.");
        } else {
            logger.info("Handheld light sources are disabled.");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (ConfigHandler.oreDictionaryEnabled) {
            OreDictionary.registerOre((String)"blockTorch", (Block)BlockRegistry.torchLit);
            OreDictionary.registerOre((String)"blockTorch", (Block)Blocks.field_150478_aa);
        }
        for (ItemStack stick : OreDictionary.getOres((String)"stickWood")) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)BlockRegistry.torchUnlit, 4), (Object[])new Object[]{"x", "y", Character.valueOf('x'), Items.field_151044_h, Character.valueOf('y'), stick});
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)BlockRegistry.torchUnlit, 4), (Object[])new Object[]{"x", "y", Character.valueOf('x'), new ItemStack(Items.field_151044_h, 1, 1), Character.valueOf('y'), stick});
        }
        for (ItemStack coal : OreDictionary.getOres((String)"itemCharcoalSugar")) {
            for (ItemStack stick : OreDictionary.getOres((String)"stickWood")) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)BlockRegistry.torchUnlit, 4), (Object[])new Object[]{"x", "y", Character.valueOf('x'), coal, Character.valueOf('y'), stick});
            }
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistry.glowstoneCrystal, 1), (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), Items.field_151114_aO, Character.valueOf('y'), coal});
        }
        for (ItemStack slab : OreDictionary.getOres((String)"slabWood")) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ItemRegistry.matchbox, 1), (Object[])new Object[]{"xxx", "yyy", Character.valueOf('x'), Items.field_151121_aF, Character.valueOf('y'), slab});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)BlockRegistry.torchLit, 1), (Object[])new Object[]{new ItemStack((Block)BlockRegistry.torchUnlit, 1), new ItemStack((Item)ItemRegistry.matchbox, 1, Short.MAX_VALUE)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistry.glowstoneCrystal, 1), (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), Items.field_151114_aO, Character.valueOf('y'), Items.field_151044_h});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Item)ItemRegistry.glowstoneCrystal, 1), (Object[])new Object[]{" x ", "xyx", " x ", Character.valueOf('x'), Items.field_151114_aO, Character.valueOf('y'), new ItemStack(Items.field_151044_h, 1, 1)});
        MinecraftForge.EVENT_BUS.register((Object)new TorchDropHandler());
        if (ConfigHandler.handheldLightEnabled) {
            FMLCommonHandler.instance().bus().register((Object)new MovingLightHandler());
        }
    }

    @Mod.EventHandler
    public void init(FMLPostInitializationEvent event) {
        if (ConfigHandler.removeRecipesEnabled) {
            RealisticTorches.removeRecipe(new ItemStack(Blocks.field_150478_aa));
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack(Blocks.field_150478_aa, 4), (Object[])new Object[]{"x", "y", Character.valueOf('x'), ItemRegistry.glowstoneCrystal, Character.valueOf('y'), Items.field_151055_y});
    }

    public static void removeRecipe(ItemStack s) {
        int recipeCount = 0;
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        for (int i = 0; i < recipeList.size(); ++i) {
            Item b;
            Item a;
            IRecipe currentRecipe = (IRecipe)recipeList.get(i);
            ItemStack output = currentRecipe.func_77571_b();
            if (output == null || (a = output.func_77973_b()) != (b = s.func_77973_b())) continue;
            recipeList.remove(i);
            ++recipeCount;
        }
        logger.info("Successfully removed " + recipeCount + " torch recipe(s).");
    }
}

