/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.handlers;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public static Configuration config;
    public static int torchBurnout;
    public static int matchboxDurability;
    public static boolean handheldLightEnabled;
    public static boolean removeRecipesEnabled;
    public static boolean unlitParticlesEnabled;
    public static boolean oreDictionaryEnabled;

    public static void loadConfig(File configFile) {
        config = new Configuration(configFile);
        config.load();
        ConfigHandler.init();
        FMLCommonHandler.instance().bus().register((Object)new ChangeListener());
    }

    public static void init() {
        String comment = "The amount of time until a torch burns out, in ticks (20 ticks = 1 second). Default: 72000";
        torchBurnout = ConfigHandler.loadInt("Torch Burnout Time", comment, torchBurnout);
        comment = "The durability of the matchbox (the number of torches that it can light before it breaks).";
        matchboxDurability = ConfigHandler.loadInt("Lighter Durability", comment, matchboxDurability);
        comment = "Should certain blocks and items emit light when held? Disabled by default due to possible performance issues.";
        handheldLightEnabled = ConfigHandler.loadBool("Handheld Light", comment, handheldLightEnabled);
        comment = "Should other mods' recipes for the vanilla torch be removed? Enabled by default.";
        removeRecipesEnabled = ConfigHandler.loadBool("Remove Recipes", comment, removeRecipesEnabled);
        comment = "Should unlit torches emit smoke particles? Disabled by default.";
        unlitParticlesEnabled = ConfigHandler.loadBool("Unlit Particles", comment, unlitParticlesEnabled);
        comment = "Should lit torches be registered in the Ore Dictionary as vanilla torch variants? Disabled by default to keep things like jack-o-lanterns balanced.";
        oreDictionaryEnabled = ConfigHandler.loadBool("Vanilla Torch Variants", comment, oreDictionaryEnabled);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int loadInt(String name, String comment, int def) {
        Property prop = config.get("general", name, def);
        prop.comment = comment;
        int val = prop.getInt(def);
        if (val <= 0) {
            val = def;
            prop.set(def);
        }
        return val;
    }

    public static boolean loadBool(String name, String comment, boolean def) {
        Property prop = config.get("general", name, def);
        prop.comment = comment;
        return prop.getBoolean(def);
    }

    static {
        torchBurnout = 72000;
        matchboxDurability = 64;
        handheldLightEnabled = false;
        removeRecipesEnabled = true;
        unlitParticlesEnabled = false;
        oreDictionaryEnabled = false;
    }

    public static class ChangeListener {
        @SubscribeEvent
        public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
            if (eventArgs.modID.equals("RealisticTorches")) {
                ConfigHandler.init();
            }
        }
    }
}

