/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.debug;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataTileEntity;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionOrphanTileEntities;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelOrphanTileEntities
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnRefresh;
    int row;

    public PanelOrphanTileEntities() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow]"));
        this.btnRefresh = new JButtonAccess("Refresh", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRefresh, "cell 1 0");
        this.btnRefresh.addActionListener(new ActionOrphanTileEntities());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.table = new JTableStats(new String[]{"Class", "Hash", "Type", "Dimension", "Coordinates"}, new Class[]{CachedString.class, String.class, CachedString.class, Integer.class, String.class}, new int[]{2, 2, 0, 0, 0});
        scrollPane.setViewportView(this.table);
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_ORPHAN_TILEENTS: {
                this.cacheData(msg, rawdata);
                this.getTable().addTableData(rawdata.array);
                DefaultTableModel model = this.getTable().getModel();
                for (ISerializable o : rawdata.array) {
                    DataTileEntity data = (DataTileEntity)o;
                    model.addRow(new Object[]{data.clazz, String.format("0x%x", data.hashCode), data.cause, data.pos.dim, String.format("[ %4d %4d %4d ]", data.pos.x, data.pos.y, data.pos.z)});
                }
                this.getTable().dataUpdated(this.row);
                break;
            }
            case LIST_ORPHAN_TILEENTS_CLEAR: {
                this.getTable().clearTableData();
                DefaultTableModel model = this.getTable().getModel();
                this.row = this.getTable().clearTable(DataTileEntity.class);
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.ORPHANTES;
    }

    public JButton getBtnRefresh() {
        return this.btnRefresh;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

