/*
 * Decompiled with CFR 0.152.
 */
package opisapache.math3.fitting;

import java.util.ArrayList;
import java.util.List;
import opisapache.math3.analysis.MultivariateMatrixFunction;
import opisapache.math3.analysis.MultivariateVectorFunction;
import opisapache.math3.analysis.ParametricUnivariateFunction;
import opisapache.math3.fitting.WeightedObservedPoint;
import opisapache.math3.optim.InitialGuess;
import opisapache.math3.optim.MaxEval;
import opisapache.math3.optim.PointVectorValuePair;
import opisapache.math3.optim.nonlinear.vector.ModelFunction;
import opisapache.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import opisapache.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;
import opisapache.math3.optim.nonlinear.vector.Target;
import opisapache.math3.optim.nonlinear.vector.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurveFitter<T extends ParametricUnivariateFunction> {
    private final MultivariateVectorOptimizer optimizer;
    private final List<WeightedObservedPoint> observations;

    public CurveFitter(MultivariateVectorOptimizer optimizer) {
        this.optimizer = optimizer;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public void addObservedPoint(double x, double y) {
        this.addObservedPoint(1.0, x, y);
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.observations.add(new WeightedObservedPoint(weight, x, y));
    }

    public void addObservedPoint(WeightedObservedPoint observed) {
        this.observations.add(observed);
    }

    public WeightedObservedPoint[] getObservations() {
        return this.observations.toArray(new WeightedObservedPoint[this.observations.size()]);
    }

    public void clearObservations() {
        this.observations.clear();
    }

    public double[] fit(T f, double[] initialGuess) {
        return this.fit(Integer.MAX_VALUE, f, initialGuess);
    }

    public double[] fit(int maxEval, T f, double[] initialGuess) {
        double[] target = new double[this.observations.size()];
        double[] weights = new double[this.observations.size()];
        int i = 0;
        for (WeightedObservedPoint point : this.observations) {
            target[i] = point.getY();
            weights[i] = point.getWeight();
            ++i;
        }
        TheoreticalValuesFunction model = new TheoreticalValuesFunction((ParametricUnivariateFunction)f);
        PointVectorValuePair optimum = this.optimizer.optimize(new MaxEval(maxEval), model.getModelFunction(), model.getModelFunctionJacobian(), new Target(target), new Weight(weights), new InitialGuess(initialGuess));
        return optimum.getPointRef();
    }

    private class TheoreticalValuesFunction {
        private final ParametricUnivariateFunction f;

        public TheoreticalValuesFunction(ParametricUnivariateFunction f) {
            this.f = f;
        }

        public ModelFunction getModelFunction() {
            return new ModelFunction(new MultivariateVectorFunction(){

                public double[] value(double[] point) {
                    double[] values = new double[CurveFitter.this.observations.size()];
                    int i = 0;
                    for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                        values[i++] = TheoreticalValuesFunction.this.f.value(observed.getX(), point);
                    }
                    return values;
                }
            });
        }

        public ModelFunctionJacobian getModelFunctionJacobian() {
            return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

                public double[][] value(double[] point) {
                    double[][] jacobian = new double[CurveFitter.this.observations.size()][];
                    int i = 0;
                    for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                        jacobian[i++] = TheoreticalValuesFunction.this.f.gradient(observed.getX(), point);
                    }
                    return jacobian;
                }
            });
        }
    }
}

