/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.chisel.client.render;

import com.cricketcraft.chisel.block.BlockSnakestone;
import com.cricketcraft.ctmlib.Drawing;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RendererSnakeStone
implements ISimpleBlockRenderingHandler {
    public static int id;

    public RendererSnakeStone() {
        id = RenderingRegistry.getNextAvailableRenderId();
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks renderer) {
        this.setRenderRotate(renderer, (BlockSnakestone)block, meta);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Drawing.drawBlock(block, meta, renderer);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        this.restoreRendererRotate(renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        this.setRenderRotate(renderer, (BlockSnakestone)block, meta);
        boolean didRender = renderer.func_147784_q(block, x, y, z);
        this.restoreRendererRotate(renderer);
        return didRender;
    }

    private void restoreRendererRotate(RenderBlocks renderer) {
        renderer.field_147871_s = 0;
        renderer.field_147875_q = 0;
        renderer.field_147873_r = 0;
        renderer.field_147869_t = 0;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }

    private void setRenderRotate(RenderBlocks renderer, BlockSnakestone block, int meta) {
        int type = meta & 0xC;
        int orient = meta & 3;
        if (type == 0) {
            switch (orient) {
                case 0: {
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 2;
                    break;
                }
                case 1: {
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 1;
                    break;
                }
                case 2: {
                    renderer.field_147867_u = 0;
                    renderer.field_147865_v = 3;
                    break;
                }
                case 3: {
                    renderer.field_147867_u = 0;
                    renderer.field_147865_v = 0;
                }
            }
        } else if (type == 4 || type == 8) {
            switch (orient) {
                case 0: {
                    renderer.field_147867_u = block.flipTopTextures ? 1 : 2;
                    renderer.field_147865_v = 1;
                    renderer.field_147873_r = 2;
                    break;
                }
                case 1: {
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 1;
                    renderer.field_147875_q = 2;
                    break;
                }
                case 2: {
                    renderer.field_147867_u = block.flipTopTextures ? 0 : 3;
                    renderer.field_147865_v = 0;
                    renderer.field_147871_s = 2;
                    break;
                }
                case 3: {
                    renderer.field_147867_u = 0;
                    renderer.field_147865_v = 0;
                    renderer.field_147869_t = 2;
                }
            }
        } else if (type == 12) {
            switch (orient) {
                case 0: {
                    renderer.field_147867_u = 0;
                    renderer.field_147865_v = 0;
                    break;
                }
                case 1: {
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 1;
                    break;
                }
                case 2: {
                    renderer.field_147869_t = 2;
                    renderer.field_147871_s = 2;
                    renderer.field_147875_q = 2;
                    renderer.field_147873_r = 2;
                }
            }
        }
    }

    public boolean shouldRender3DInInventory(int renderId) {
        return true;
    }

    public int getRenderId() {
        return id;
    }
}

