/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.ctmlib;

import com.cricketcraft.ctmlib.CTM;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public enum Dir {
    TOP(ForgeDirection.UP),
    TOP_RIGHT(ForgeDirection.UP, ForgeDirection.EAST),
    RIGHT(ForgeDirection.EAST),
    BOTTOM_RIGHT(ForgeDirection.DOWN, ForgeDirection.EAST),
    BOTTOM(ForgeDirection.DOWN),
    BOTTOM_LEFT(ForgeDirection.DOWN, ForgeDirection.WEST),
    LEFT(ForgeDirection.WEST),
    TOP_LEFT(ForgeDirection.UP, ForgeDirection.WEST);

    public static final Dir[] VALUES;
    private static final ForgeDirection NORMAL;
    private ForgeDirection[] dirs;

    private Dir(ForgeDirection ... dirs) {
        this.dirs = dirs;
    }

    public boolean isConnected(CTM inst, IBlockAccess world, int x, int y, int z, int sideIdx, Block block, int meta) {
        ForgeDirection[] dirs;
        ForgeDirection side = ForgeDirection.getOrientation((int)sideIdx);
        for (ForgeDirection dir : dirs = this.getNormalizedDirs(side)) {
            x += dir.offsetX;
            y += dir.offsetY;
            z += dir.offsetZ;
        }
        return inst.isConnected(world, x, y, z, side, block, meta);
    }

    private ForgeDirection[] getNormalizedDirs(ForgeDirection normal) {
        if (normal == NORMAL) {
            return this.dirs;
        }
        if (normal == NORMAL.getOpposite()) {
            ForgeDirection[] ret = new ForgeDirection[this.dirs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.dirs[i].offsetY != 0 ? this.dirs[i] : this.dirs[i].getOpposite();
            }
            return ret;
        }
        ForgeDirection axis = null;
        axis = normal.offsetY == 0 ? (normal == NORMAL.getRotation(ForgeDirection.UP) ? ForgeDirection.UP : ForgeDirection.DOWN) : (normal == ForgeDirection.UP ? NORMAL.getRotation(ForgeDirection.DOWN) : NORMAL.getRotation(ForgeDirection.UP));
        ForgeDirection[] ret = new ForgeDirection[this.dirs.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.dirs[i].getRotation(axis);
        }
        return ret;
    }

    static {
        VALUES = Dir.values();
        NORMAL = ForgeDirection.SOUTH;
    }
}

