/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import toast.mobProperties.IProperty;
import toast.mobProperties.MobProperties;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.entry.PropertyExternal;
import toast.mobProperties.entry.drops.EntryDropsSchematic;

public abstract class FileHelper {
    public static File CONFIG_DIRECTORY;
    public static File PROPS_DIRECTORY;
    public static File EXTERNAL_DIRECTORY;
    public static File SCHEMATIC_DIRECTORY;
    public static final String FILE_EXT = ".json";
    public static final String SCHEMATIC_FILE_EXT = ".schematic";
    private static final JsonParser PARSER;
    private static final Gson GSON_PRETTY;
    private static final Gson GSON_COMPACT;
    public static final char CHAR_RAND = '~';
    public static final char CHAR_INVERT = '!';

    public static void init(File directory) {
        CONFIG_DIRECTORY = directory;
        PROPS_DIRECTORY = new File(directory, "MobProperties");
        PROPS_DIRECTORY.mkdirs();
        EXTERNAL_DIRECTORY = new File(directory, "MobPropertiesExternal");
        EXTERNAL_DIRECTORY.mkdirs();
        SCHEMATIC_DIRECTORY = new File(directory, "MobPropertiesSchematics");
        SCHEMATIC_DIRECTORY.mkdirs();
    }

    public static int load() {
        String[] types;
        int filesLoaded = 0;
        for (String type : types = new String[]{"drops", "items", "nbt", "stats"}) {
            File externalDir = new File(EXTERNAL_DIRECTORY, type);
            externalDir.mkdirs();
            filesLoaded += FileHelper.loadExternalDirectory(type, externalDir);
        }
        filesLoaded += FileHelper.loadDirectory(PROPS_DIRECTORY);
        return filesLoaded += FileHelper.loadSchematicDirectory(SCHEMATIC_DIRECTORY);
    }

    private static int loadDirectory(File directory) {
        int filesLoaded = 0;
        for (File propFile : directory.listFiles(new ExtensionFilter(FILE_EXT))) {
            JsonObject node = FileHelper.loadFile(propFile);
            MobProperties.load(propFile.getPath(), node);
            ++filesLoaded;
        }
        for (File subDirectory : directory.listFiles(new FolderFilter())) {
            filesLoaded += FileHelper.loadDirectory(subDirectory);
        }
        return filesLoaded;
    }

    private static int loadExternalDirectory(String type, File directory) {
        int filesLoaded = 0;
        for (File propFile : directory.listFiles(new ExtensionFilter(FILE_EXT))) {
            PropertyExternal.load(type, propFile.getPath(), propFile.getName(), FileHelper.loadFile(propFile));
            ++filesLoaded;
        }
        for (File subDirectory : directory.listFiles(new FolderFilter())) {
            filesLoaded += FileHelper.loadExternalDirectory(type, subDirectory);
        }
        return filesLoaded;
    }

    private static int loadSchematicDirectory(File directory) {
        int filesLoaded = 0;
        for (File schematicFile : directory.listFiles(new ExtensionFilter(SCHEMATIC_FILE_EXT))) {
            try {
                EntryDropsSchematic.load(schematicFile.getPath(), schematicFile.getName(), FileHelper.loadUncompressedNBTFile(schematicFile));
            }
            catch (MobPropertyException ex) {
                EntryDropsSchematic.load(schematicFile.getPath(), schematicFile.getName(), FileHelper.loadNBTFile(schematicFile));
            }
            ++filesLoaded;
        }
        for (File subDirectory : directory.listFiles(new FolderFilter())) {
            filesLoaded += FileHelper.loadSchematicDirectory(subDirectory);
        }
        return filesLoaded;
    }

    private static JsonObject loadFile(File propFile) {
        JsonElement node = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(propFile)));
            node = PARSER.parse((Reader)in);
            in.close();
        }
        catch (Exception ex) {
            throw new MobPropertyException("Error reading file! (See \"Caused by:\" below for more info.)", propFile.getPath(), ex);
        }
        if (node == null) {
            throw new MobPropertyException("Failed to read file!", propFile.getPath());
        }
        if (!node.isJsonObject()) {
            throw new MobPropertyException("Invalid file! (non-object)", propFile.getPath());
        }
        return node.getAsJsonObject();
    }

    private static NBTTagCompound loadNBTFile(File nbtFile) {
        try {
            if (nbtFile.exists()) {
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(nbtFile));
            }
        }
        catch (Exception ex) {
            throw new MobPropertyException("Error reading nbt file!", nbtFile.getPath(), ex);
        }
        throw new MobPropertyException("Failed to read nbt file!", nbtFile.getPath());
    }

    private static NBTTagCompound loadUncompressedNBTFile(File nbtFile) {
        try {
            if (nbtFile.exists()) {
                return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(new FileInputStream(nbtFile)));
            }
        }
        catch (Exception ex) {
            throw new MobPropertyException("Error reading uncompressed nbt file!", nbtFile.getPath(), ex);
        }
        throw new MobPropertyException("Failed to read uncompressed nbt file!", nbtFile.getPath());
    }

    public static int generateDefaults() {
        JsonObject defaultProps;
        int filesGenerated = 0;
        File defaultPropFile = new File(CONFIG_DIRECTORY, "MobProperties.json");
        if (!defaultPropFile.exists()) {
            defaultProps = new JsonObject();
            defaultProps.addProperty("_comment", "This is the default Mop Properties file. When this mod generates a default file for any mob, it will be an auto-formatted copy of this file. Remember, comments outside of functions (such as this one) will not be copied.");
            defaultProps.add("drops", (JsonElement)new JsonArray());
            defaultProps.add("pre_stats", (JsonElement)new JsonArray());
            defaultProps.add("stats", (JsonElement)new JsonArray());
            try {
                defaultPropFile.createNewFile();
                FileWriter out = new FileWriter(defaultPropFile);
                GSON_PRETTY.toJson((JsonElement)defaultProps, (Appendable)out);
                out.close();
                ++filesGenerated;
            }
            catch (Exception ex) {
                _MobPropertiesMod.console("[WARNING] Failed to generate the default properties file!");
            }
        } else {
            defaultProps = FileHelper.loadFile(defaultPropFile);
        }
        for (Map.Entry mobEntry : EntityList.field_75625_b.entrySet()) {
            if (MobProperties.getProperties((String)mobEntry.getKey()) != null || !EntityLivingBase.class.isAssignableFrom((Class)mobEntry.getValue()) || Modifier.isAbstract(((Class)mobEntry.getValue()).getModifiers())) continue;
            File directory = PROPS_DIRECTORY;
            String fileName = (String)mobEntry.getKey();
            String[] split = fileName.split("\\.", 2);
            if (split.length > 1) {
                fileName = split[1];
                char[] dirNameArray = split[0].toCharArray();
                split[0] = "";
                for (char letter : dirNameArray) {
                    split[0] = split[0] + (Character.isLetterOrDigit(letter) ? Character.toString(letter) : "_");
                }
                directory = new File(directory, split[0]);
                directory.mkdirs();
            }
            char[] fileNameArray = fileName.toCharArray();
            fileName = "";
            for (char letter : fileNameArray) {
                fileName = fileName + (Character.isLetterOrDigit(letter) ? Character.toString(letter) : "_");
            }
            try {
                File propFile = new File(directory, fileName + FILE_EXT);
                if (propFile.exists()) {
                    int attempt;
                    for (attempt = 0; attempt < 100 && (propFile = new File(directory, fileName + attempt + FILE_EXT)).exists(); ++attempt) {
                    }
                    if (attempt > 99) {
                        _MobPropertiesMod.console("[WARNING] Failed to generate default properties file for \"" + (String)mobEntry.getKey() + "\"!");
                        continue;
                    }
                    fileName = fileName + attempt;
                }
                JsonObject props = new JsonObject();
                props.addProperty("_name", (String)mobEntry.getKey());
                for (Map.Entry entry : defaultProps.entrySet()) {
                    if (entry.getKey() == null || ((String)entry.getKey()).equals("_name") || ((String)entry.getKey()).equals("_comment")) continue;
                    props.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
                propFile.createNewFile();
                FileWriter out = new FileWriter(propFile);
                GSON_PRETTY.toJson((JsonElement)props, (Appendable)out);
                out.close();
                ++filesGenerated;
                MobProperties.load(propFile.getPath(), props);
            }
            catch (MobPropertyException ex) {
                throw ex;
            }
            catch (Exception ex) {
                _MobPropertiesMod.console("[WARNING] Failed to generate default properties file for \"" + (String)mobEntry.getKey() + "\"!");
                ex.printStackTrace();
            }
        }
        return filesGenerated;
    }

    public static void verify(JsonObject node, String path, IProperty property) {
        List<String> required = Arrays.asList(property.getRequiredFields());
        List<String> optional = Arrays.asList(property.getOptionalFields());
        HashSet<String> allowed = new HashSet<String>();
        allowed.addAll(required);
        allowed.addAll(optional);
        allowed.add("_comment");
        if (!(property instanceof MobProperties)) {
            allowed.add("function");
        }
        if (path.matches("^.*\\\\entry_[0-9]+\\(choose\\)\\\\functions\\\\entry_[0-9]+\\(\\w+\\)$")) {
            allowed.add("weight");
        }
        try {
            Set fields = node.entrySet();
            HashSet fieldNames = new HashSet();
            for (Map.Entry entry : fields) {
                fieldNames.add(entry.getKey());
            }
            for (String name : required) {
                if (fieldNames.contains(name)) continue;
                throw new MobPropertyException("Verify error! Missing required field \"" + name + "\". (Required fields: " + Arrays.toString(property.getRequiredFields()) + ")", path);
            }
            for (String name : fieldNames) {
                if (allowed.contains(name)) continue;
                throw new MobPropertyException("Verify error! Invalid field \"" + name + "\". (Allowed fields: " + Arrays.toString(allowed.toArray(new String[0])) + ")", path);
            }
        }
        catch (IllegalStateException ex) {
            throw new MobPropertyException("Verify error! (functions must be objects)", path);
        }
    }

    public static String getFunctionString(JsonObject node, String path) {
        try {
            return GSON_COMPACT.toJson((JsonElement)node);
        }
        catch (Exception ex) {
            throw new MobPropertyException("Error generating function string!", path, ex);
        }
    }

    public static JsonObject loadFunctionFromString(String path, String prop, int index) {
        try {
            path = path + "\\entry_" + (index + 1);
            JsonObject node = null;
            try {
                node = PARSER.parse(prop).getAsJsonObject();
            }
            catch (Exception ex) {
                throw new MobPropertyException("Error loading function string! " + prop, path, ex);
            }
            if (node == null) {
                throw new MobPropertyException("Failed to load function string! " + prop, path);
            }
            if (!node.isJsonObject()) {
                throw new MobPropertyException("Invalid function string! (non-object) " + prop, path);
            }
            return node;
        }
        catch (MobPropertyException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static double getValue(double[] values) {
        return FileHelper.getCount(values, _MobPropertiesMod.random);
    }

    public static double getValue(double[] values, Random random) {
        if (values[0] == values[1]) {
            return values[0];
        }
        return random.nextDouble() * (values[1] - values[0]) + values[0];
    }

    public static int getCount(double[] counts) {
        return FileHelper.getCount(counts, _MobPropertiesMod.random);
    }

    public static int getCount(double[] counts, Random random) {
        int intCount;
        double count = FileHelper.getValue(counts, random);
        if (0.0 < (count -= (double)(intCount = (int)Math.floor(count))) && random.nextDouble() < count) {
            ++intCount;
        }
        return intCount;
    }

    public static long getLongCount(double[] counts) {
        return FileHelper.getLongCount(counts, _MobPropertiesMod.random);
    }

    public static long getLongCount(double[] counts, Random random) {
        long longCount;
        double count = FileHelper.getValue(counts, random);
        if (0.0 < (count -= (double)(longCount = (long)Math.floor(count))) && random.nextDouble() < count) {
            ++longCount;
        }
        return longCount;
    }

    public static String readText(JsonObject node, String path, String tag, String defaultValue) {
        try {
            return node.get(tag).getAsString();
        }
        catch (NullPointerException ex) {
            return defaultValue;
        }
        catch (Exception ex) {
            throw new MobPropertyException("Invalid value for \"" + tag + "\"! (wrong node type)", path);
        }
    }

    public static boolean readBoolean(JsonObject node, String path, String tag, boolean defaultValue) {
        String text = FileHelper.readText(node, path, tag, Boolean.toString(defaultValue));
        if (text.equals("false")) {
            return false;
        }
        if (text.equals("true")) {
            return true;
        }
        throw new MobPropertyException("Invalid boolean value! (" + text + ": must be true or false)", path);
    }

    public static double[] readCounts(JsonObject node, String path, String tag, int index, double defaultMin, double defaultMax) {
        path = path + "\\" + tag + "\\entry_" + (index + 1);
        String value = "";
        try {
            value = node.getAsJsonArray(tag).get(index).getAsString();
        }
        catch (NullPointerException ex) {
            return new double[]{defaultMin, defaultMax};
        }
        catch (IndexOutOfBoundsException ex) {
            throw new MobPropertyException("Unexpected error! (array index out of bounds)", path);
        }
        catch (Exception ex) {
            throw new MobPropertyException("Invalid number range! (wrong node type)", path);
        }
        return FileHelper.readCounts(value, path);
    }

    public static double[] readCounts(JsonObject node, String path, String tag, double defaultMin, double defaultMax) {
        path = path + "\\" + tag;
        String value = "";
        try {
            value = node.get(tag).getAsString();
        }
        catch (NullPointerException ex) {
            return new double[]{defaultMin, defaultMax};
        }
        catch (Exception ex) {
            throw new MobPropertyException("Invalid number range! (wrong node type)", path);
        }
        return FileHelper.readCounts(value, path);
    }

    private static double[] readCounts(String value, String path) {
        double[] counts = new double[2];
        String[] subParts = value.split(Character.toString('~'));
        try {
            counts[0] = subParts[0].startsWith("0x") ? (double)Integer.parseInt(subParts[0].substring(2), 16) : Double.valueOf(subParts[0]);
        }
        catch (Exception ex) {
            throw new MobPropertyException("Invalid number range! (" + subParts[0].trim() + ")", path);
        }
        if (subParts.length == 1) {
            counts[1] = counts[0];
        } else if (subParts.length == 2) {
            try {
                if (subParts[1].startsWith("0x")) {
                    counts[1] = Integer.parseInt(subParts[1].substring(2), 16);
                }
                counts[1] = Double.valueOf(subParts[1]);
            }
            catch (Exception ex) {
                throw new MobPropertyException("Invalid number range! (" + subParts[1].trim() + ")", path);
            }
        } else {
            throw new MobPropertyException("Invalid number range! (too many '~'s)", path);
        }
        if (Double.isNaN(counts[0]) || Double.isNaN(counts[1]) || Double.isInfinite(counts[0]) || Double.isInfinite(counts[1])) {
            throw new MobPropertyException("Invalid number range! (NaN and Infinity are not allowed)", path);
        }
        if (counts[0] > counts[1]) {
            double temp = counts[0];
            counts[0] = counts[1];
            counts[1] = temp;
        }
        return counts;
    }

    public static int readWeight(JsonObject node, String path, int defaultValue) {
        String value = "";
        try {
            value = node.get("weight").getAsString();
        }
        catch (NullPointerException ex) {
            return defaultValue;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new MobPropertyException("Unexpected error! (array index out of bounds)", path);
        }
        catch (Exception ex) {
            throw new MobPropertyException("Invalid number range! (wrong node type)", path);
        }
        try {
            int weight = Integer.parseInt(value);
            if (weight < 0) {
                throw new MobPropertyException("Invalid weight! (" + value + ": must be non-negative)", path);
            }
            return weight;
        }
        catch (NumberFormatException ex) {
            throw new MobPropertyException("Invalid weight! (" + value + ")", path, ex);
        }
    }

    public static int readInteger(JsonObject node, String path, String tag, int defaultValue) {
        path = path + "\\" + tag;
        String value = "";
        try {
            value = node.get(tag).getAsString();
        }
        catch (NullPointerException ex) {
            return defaultValue;
        }
        catch (Exception ex) {
            throw new MobPropertyException("Invalid integer! (wrong node type)", path);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new MobPropertyException("Invalid integer! (" + value + ")", path, ex);
        }
    }

    public static Item readItem(JsonObject node, String path, String tag) {
        return FileHelper.readItem(node, path, tag, true);
    }

    public static Item readItem(JsonObject node, String path, String tag, boolean required) {
        return FileHelper.readItem(FileHelper.readText(node, path, tag, ""), path, required);
    }

    public static Item readItem(String id, String path, boolean required) {
        Item item = (Item)Item.field_150901_e.func_82594_a(id);
        if (item == null) {
            try {
                item = Item.func_150899_d((int)Integer.parseInt(id));
                if (item != null) {
                    _MobPropertiesMod.console("[WARNING] Usage of numerical item id! (" + id + "=\"" + Item.field_150901_e.func_148750_c((Object)item) + "\") at " + path);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (required && item == null) {
            throw new MobPropertyException("Missing or invalid item! (" + id + ")", path);
        }
        return item;
    }

    public static Block readBlock(JsonObject node, String path, String tag) {
        return FileHelper.readBlock(node, path, tag, true);
    }

    public static Block readBlock(JsonObject node, String path, String tag, boolean required) {
        return FileHelper.readBlock(FileHelper.readText(node, path, tag, ""), path, required);
    }

    public static Block readBlock(String id, String path, boolean required) {
        if (id.equals("air") || id.equals("minecraft:air")) {
            return Blocks.field_150350_a;
        }
        Block block = (Block)Block.field_149771_c.func_82594_a(id);
        if (block == null || block == Blocks.field_150350_a) {
            try {
                block = Block.func_149729_e((int)Integer.parseInt(id));
                if (block != null && block != Blocks.field_150350_a) {
                    _MobPropertiesMod.console("[WARNING] Usage of numerical block id! (" + id + "=\"" + Block.field_149771_c.func_148750_c((Object)block) + "\") at " + path);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (required && (block == null || block == Blocks.field_150350_a)) {
            throw new MobPropertyException("Missing or invalid block! (" + id + ")", path);
        }
        return block;
    }

    public static Potion readPotion(JsonObject node, String path, String tag) {
        return FileHelper.readPotion(node, path, tag, true);
    }

    public static Potion readPotion(JsonObject node, String path, String tag, boolean required) {
        return FileHelper.readPotion(FileHelper.readText(node, path, tag, ""), path, required);
    }

    public static Potion readPotion(String id, String path, boolean required) {
        Potion potion = null;
        for (Potion potionType : Potion.field_76425_a) {
            if (potionType == null || !id.equals(potionType.func_76393_a())) continue;
            potion = potionType;
            break;
        }
        if (potion == null) {
            try {
                potion = Potion.field_76425_a[Integer.parseInt(id)];
                if (potion != null) {
                    _MobPropertiesMod.console("[WARNING] Usage of numerical potion id! (" + id + "=\"" + potion.func_76393_a() + "\") at " + path);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (required && potion == null) {
            throw new MobPropertyException("Missing or invalid potion! (" + id + ")", path);
        }
        return potion;
    }

    public static Enchantment readEnchant(JsonObject node, String path, String tag) {
        return FileHelper.readEnchant(node, path, tag, true);
    }

    public static Enchantment readEnchant(JsonObject node, String path, String tag, boolean required) {
        return FileHelper.readEnchant(FileHelper.readText(node, path, tag, ""), path, required);
    }

    public static Enchantment readEnchant(String id, String path, boolean required) {
        Enchantment enchant = null;
        for (Enchantment enchantType : Enchantment.field_77331_b) {
            if (enchantType == null || !id.equals(enchantType.func_77320_a())) continue;
            enchant = enchantType;
            break;
        }
        if (enchant == null) {
            try {
                enchant = Enchantment.field_77331_b[Integer.parseInt(id)];
                if (enchant != null) {
                    _MobPropertiesMod.console("[WARNING] Usage of numerical enchantment id! (" + id + "=\"" + enchant.func_77320_a() + "\") at " + path);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (required && enchant == null) {
            throw new MobPropertyException("Missing or invalid enchantment! (" + id + ")", path);
        }
        return enchant;
    }

    static {
        PARSER = new JsonParser();
        GSON_PRETTY = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        GSON_COMPACT = new GsonBuilder().disableHtmlEscaping().create();
    }

    public static class FolderFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    public static class ExtensionFilter
    implements FilenameFilter {
        private final String extension;

        public ExtensionFilter(String ext) {
            this.extension = ext;
        }

        @Override
        public boolean accept(File file, String name) {
            return name.toLowerCase().endsWith(this.extension);
        }
    }
}

