/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IProperty;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.MobPropertyException;
import toast.mobProperties._MobPropertiesMod;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.DropsHelper;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.ItemStatsInfo;
import toast.mobProperties.entry.MobDropsInfo;
import toast.mobProperties.entry.MobStatsInfo;
import toast.mobProperties.entry.NBTStatsInfo;

public class PropertyChoose
extends EntryAbstract
implements IPropertyDrops {
    private final double[] counts;
    private final IProperty[] entries;
    private final int[] weights;
    private final int totalWeight;

    public PropertyChoose(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.counts = FileHelper.readCounts(node, path, "count", 1.0, 1.0);
        JsonArray nodes = node.getAsJsonArray("functions");
        if (nodes == null) {
            throw new MobPropertyException("Missing or invalid functions!", path);
        }
        path = path + "\\functions";
        int length = nodes.size();
        this.entries = new IProperty[length];
        this.weights = new int[length];
        for (int i = 0; i < length; ++i) {
            JsonElement subnode = nodes.get(i);
            String subpath = path + "\\entry_" + (i + 1);
            if (!subnode.isJsonObject()) {
                throw new MobPropertyException("Invalid node (object expected)!", subpath);
            }
            this.weights[i] = FileHelper.readWeight(subnode.getAsJsonObject(), subpath, 1);
            if (this.weights[i] <= 0) {
                throw new MobPropertyException("Invalid property weight! (" + this.weights[0] + ": must be a positive integer)", path);
            }
            this.entries[i] = subnode.getAsJsonObject().has("function") ? loader.readLine(path, root, i, subnode) : null;
        }
        int weight = 0;
        int i = length;
        while (i-- > 0) {
            weight += this.weights[i];
        }
        this.totalWeight = weight;
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"functions"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"count"};
    }

    @Override
    public void init(MobStatsInfo mobStats) {
        if (this.totalWeight <= 0) {
            return;
        }
        int count = FileHelper.getCount(this.counts);
        block0: while (count-- > 0) {
            int choice = mobStats.theEntity.func_70681_au().nextInt(this.totalWeight);
            int i = this.weights.length;
            while (i-- > 0) {
                if ((choice -= this.weights[i]) >= 0) continue;
                if (this.entries[i] == null) continue block0;
                this.entries[i].init(mobStats);
                continue block0;
            }
            _MobPropertiesMod.debugException("Error choosing weighted item! " + choice + "/" + this.totalWeight);
        }
    }

    @Override
    public void modifyItem(ItemStatsInfo itemStats) {
        if (this.totalWeight <= 0) {
            return;
        }
        int count = FileHelper.getCount(this.counts);
        block0: while (count-- > 0) {
            int choice = itemStats.theEntity.func_70681_au().nextInt(this.totalWeight);
            int i = this.weights.length;
            while (i-- > 0) {
                if ((choice -= this.weights[i]) >= 0) continue;
                if (this.entries[i] == null) continue block0;
                this.entries[i].modifyItem(itemStats);
                continue block0;
            }
            _MobPropertiesMod.debugException("Error choosing weighted item! " + choice + "/" + this.totalWeight);
        }
    }

    @Override
    public void addTags(NBTStatsInfo nbtStats) {
        if (this.totalWeight <= 0) {
            return;
        }
        int count = FileHelper.getCount(this.counts);
        block0: while (count-- > 0) {
            int choice = nbtStats.theEntity.func_70681_au().nextInt(this.totalWeight);
            int i = this.weights.length;
            while (i-- > 0) {
                if ((choice -= this.weights[i]) >= 0) continue;
                if (this.entries[i] == null) continue block0;
                this.entries[i].addTags(nbtStats);
                continue block0;
            }
            _MobPropertiesMod.debugException("Error choosing weighted item! " + choice + "/" + this.totalWeight);
        }
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        if (this.totalWeight <= 0) {
            return;
        }
        int count = FileHelper.getCount(this.counts);
        block0: while (count-- > 0) {
            int choice = mobDrops.theEntity.func_70681_au().nextInt(this.totalWeight);
            int i = this.weights.length;
            while (i-- > 0) {
                if ((choice -= this.weights[i]) >= 0) continue;
                if (this.entries[i] == null) continue block0;
                this.entries[i].modifyDrops(mobDrops);
                continue block0;
            }
            _MobPropertiesMod.debugException("Error choosing weighted item! " + choice + "/" + this.totalWeight);
        }
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        if (this.totalWeight <= 0) {
            return;
        }
        if ((chance = DropsHelper.adjustAttemptsAndChance(this.counts, attempts, chance) / (double)this.totalWeight) > 0.0) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (!(this.entries[i] instanceof IPropertyDrops)) continue;
                ((IPropertyDrops)((Object)this.entries[i])).addDrops(dropsList, DropsHelper.copy(attempts), chance * (double)this.weights[i], DropsHelper.copy(conditions));
            }
        }
    }
}

