/*
 * Decompiled with CFR 0.152.
 */
package toast.mobProperties.entry.drops;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.item.Item;
import toast.mobProperties.FileHelper;
import toast.mobProperties.IPropertyReader;
import toast.mobProperties.api.DropEntry;
import toast.mobProperties.api.IPropertyDrops;
import toast.mobProperties.entry.EntryAbstract;
import toast.mobProperties.entry.MobDropsInfo;

public class EntryDropsRemove
extends EntryAbstract
implements IPropertyDrops {
    private final Item item;
    private final double[] damages;
    private final double[] counts;

    public EntryDropsRemove(String path, JsonObject root, int index, JsonObject node, IPropertyReader loader) {
        super(node, path);
        this.item = FileHelper.readItem(node, path, "id");
        this.damages = FileHelper.readCounts(node, path, "damage", -1.0, -1.0);
        this.counts = FileHelper.readCounts(node, path, "count", 2.147483647E9, 2.147483647E9);
    }

    @Override
    public String[] getRequiredFields() {
        return new String[]{"id"};
    }

    @Override
    public String[] getOptionalFields() {
        return new String[]{"damage", "count"};
    }

    @Override
    public void modifyDrops(MobDropsInfo mobDrops) {
        int damage = FileHelper.getCount(this.damages, mobDrops.random);
        int count = FileHelper.getCount(this.counts, mobDrops.random);
        mobDrops.addDrop(this.item, damage, -count, null);
    }

    @Override
    public void addDrops(List<DropEntry> dropsList, double[] attempts, double chance, List<String> conditions) {
        double[] countsBuf = new double[]{-this.counts[0], -this.counts[1]};
        if (countsBuf[0] == -2.147483647E9) {
            countsBuf[1] = Double.NEGATIVE_INFINITY;
            countsBuf[0] = Double.NEGATIVE_INFINITY;
        }
        dropsList.add(new DropEntry(this.item, this.damages, countsBuf, attempts, chance, conditions));
    }
}

