/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.network;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.EntityUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.chunk.Chunk;

public class MalisisNetwork
extends SimpleNetworkWrapper {
    private int discriminator = 0;
    protected String name;

    public MalisisNetwork(String channelName) {
        super(channelName);
        this.name = channelName;
    }

    public MalisisNetwork(IMalisisMod mod) {
        this(mod.getModId());
    }

    public void sendToPlayersWatchingChunk(IMessage message, Chunk chunk) {
        for (EntityPlayerMP player : EntityUtils.getPlayersWatchingChunk(chunk)) {
            this.sendTo(message, player);
        }
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, Side side) {
        super.registerMessage(messageHandler, requestMessageType, this.discriminator++, side);
        MalisisCore.log.info("Registering " + messageHandler.getSimpleName() + " for " + requestMessageType.getSimpleName() + " with discriminator " + this.discriminator + " in channel " + this.name);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(IMessageHandler<? super REQ, ? extends REPLY> messageHandler, Class<REQ> requestMessageType, Side side) {
        super.registerMessage(messageHandler, requestMessageType, this.discriminator++, side);
        MalisisCore.log.info("Registering " + messageHandler.getClass().getSimpleName() + " for " + requestMessageType.getSimpleName() + " with discriminator " + this.discriminator + " in channel " + this.name);
    }

    public int getNextDiscriminator() {
        return this.discriminator++;
    }

    public static void createMessages(ASMDataTable asmDataTable) {
        List classes = Ordering.natural().onResultOf((Function)new Function<ASMDataTable.ASMData, String>(){

            public String apply(ASMDataTable.ASMData data) {
                return data.getClassName();
            }
        }).sortedCopy((Iterable)asmDataTable.getAll(MalisisMessage.class.getName()));
        for (ASMDataTable.ASMData data : classes) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (IMessageHandler.class.isAssignableFrom(clazz)) {
                    clazz.newInstance();
                    continue;
                }
                MalisisCore.log.error("@MalisisMessage found on {} that does not implement IMessageHandler", new Object[]{data.getClassName()});
            }
            catch (Exception e) {
                MalisisCore.log.error("Could not create {} message.", new Object[]{data.getClassName(), e});
            }
        }
    }
}

