/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.common.Mekanism;
import mekanism.generators.common.network.PacketGeneratorsGui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class GeneratorsPacketHandler {
    public SimpleNetworkWrapper netHandler = NetworkRegistry.INSTANCE.newSimpleChannel("MEKGEN");

    public void initialize() {
        this.netHandler.registerMessage(PacketGeneratorsGui.class, PacketGeneratorsGui.GeneratorsGuiMessage.class, 0, Side.SERVER);
        this.netHandler.registerMessage(PacketGeneratorsGui.class, PacketGeneratorsGui.GeneratorsGuiMessage.class, 0, Side.CLIENT);
    }

    public static void encode(Object[] dataValues, ByteBuf output) {
        try {
            for (Object data : dataValues) {
                if (data instanceof Integer) {
                    output.writeInt(((Integer)data).intValue());
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean(((Boolean)data).booleanValue());
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble(((Double)data).doubleValue());
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    GeneratorsPacketHandler.writeString(output, (String)data);
                    continue;
                }
                if (data instanceof Byte) {
                    output.writeByte((int)((Byte)data).byteValue());
                    continue;
                }
                if (data instanceof int[]) {
                    for (int i : (int[])data) {
                        output.writeInt(i);
                    }
                    continue;
                }
                if (data instanceof byte[]) {
                    for (byte b : (byte[])data) {
                        output.writeByte((int)b);
                    }
                    continue;
                }
                if (!(data instanceof ArrayList)) continue;
                GeneratorsPacketHandler.encode(((ArrayList)data).toArray(), output);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Error while encoding packet data.");
            e.printStackTrace();
        }
    }

    public static void writeString(ByteBuf output, String s) {
        output.writeInt(s.getBytes().length);
        output.writeBytes(s.getBytes());
    }

    public static String readString(ByteBuf input) {
        return new String(input.readBytes(input.readInt()).array());
    }

    public static EntityPlayer getPlayer(MessageContext context) {
        return Mekanism.proxy.getPlayer(context);
    }

    public void sendToAll(IMessage message) {
        this.netHandler.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.netHandler.sendTo(message, player);
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.netHandler.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.netHandler.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.netHandler.sendToServer(message);
    }

    public void sendToCuboid(IMessage message, AxisAlignedBB cuboid, int dimId) {
        MinecraftServer server = MinecraftServer.func_71276_C();
        if (server != null && cuboid != null) {
            for (EntityPlayerMP player : server.func_71203_ab().field_72404_b) {
                if (player.field_71093_bK != dimId || !cuboid.func_72318_a(Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v))) continue;
                this.sendTo(message, player);
            }
        }
    }
}

