/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.IHeatTransfer;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.reactor.IReactorBlock;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.util.CableUtils;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.generators.common.item.ItemHohlraum;
import mekanism.generators.common.tile.reactor.TileEntityReactorBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityReactorPort
extends TileEntityReactorBlock
implements IFluidHandler,
IGasHandler,
ITubeConnection,
IHeatTransfer {
    public TileEntityReactorPort() {
        super("name", 1.0);
        this.inventory = new ItemStack[0];
    }

    public boolean isFrame() {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.changed) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
        super.onUpdate();
        CableUtils.emit((IEnergyWrapper)this);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid() == FluidRegistry.WATER && this.getReactor() != null) {
            return this.getReactor().getWaterTank().fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource.getFluid() == FluidRegistry.getFluid((String)"steam") && this.getReactor() != null) {
            this.getReactor().getSteamTank().drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getReactor() != null) {
            return this.getReactor().getSteamTank().drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getReactor() != null && fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getReactor() != null && fluid == FluidRegistry.WATER;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this.getReactor() == null) {
            return new FluidTankInfo[0];
        }
        return new FluidTankInfo[]{this.getReactor().getWaterTank().getInfo(), this.getReactor().getSteamTank().getInfo()};
    }

    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.getReactor() != null) {
            if (stack.getGas() == GasRegistry.getGas((String)"deuterium")) {
                return this.getReactor().getDeuteriumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == GasRegistry.getGas((String)"tritium")) {
                return this.getReactor().getTritiumTank().receive(stack, doTransfer);
            }
            if (stack.getGas() == GasRegistry.getGas((String)"fusionFuelDT")) {
                return this.getReactor().getFuelTank().receive(stack, doTransfer);
            }
        }
        return 0;
    }

    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (this.getReactor() != null && this.getReactor().getSteamTank().getFluidAmount() > 0) {
            return new GasStack(GasRegistry.getGas((String)"steam"), this.getReactor().getSteamTank().drain((int)amount, (boolean)doTransfer).amount);
        }
        return null;
    }

    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas((String)"deuterium") || type == GasRegistry.getGas((String)"tritium") || type == GasRegistry.getGas((String)"fusionFuelDT");
    }

    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return type == GasRegistry.getGas((String)"steam");
    }

    public boolean canTubeConnect(ForgeDirection side) {
        return this.getReactor() != null;
    }

    public boolean canOutputTo(ForgeDirection side) {
        return true;
    }

    public double getEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferedEnergy();
    }

    public void setEnergy(double energy) {
        if (this.getReactor() != null) {
            this.getReactor().setBufferedEnergy(energy);
        }
    }

    public double getMaxEnergy() {
        if (this.getReactor() == null) {
            return 0.0;
        }
        return this.getReactor().getBufferSize();
    }

    @Override
    public EnumSet<ForgeDirection> getOutputtingSides() {
        EnumSet<ForgeDirection> set = EnumSet.allOf(ForgeDirection.class);
        set.remove(ForgeDirection.UNKNOWN);
        return set;
    }

    @Override
    public EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public double getMaxOutput() {
        return 1.0E9;
    }

    public double getTemp() {
        if (this.getReactor() != null) {
            return this.getReactor().getTemp();
        }
        return 0.0;
    }

    public double getInverseConductionCoefficient() {
        return 5.0;
    }

    public double getInsulationCoefficient(ForgeDirection side) {
        if (this.getReactor() != null) {
            return this.getReactor().getInsulationCoefficient(side);
        }
        return 0.0;
    }

    public void transferHeatTo(double heat) {
        if (this.getReactor() != null) {
            this.getReactor().transferHeatTo(heat);
        }
    }

    public double[] simulateHeat() {
        return HeatUtils.simulate((IHeatTransfer)this);
    }

    public double applyTemperatureChange() {
        if (this.getReactor() != null) {
            return this.getReactor().applyTemperatureChange();
        }
        return 0.0;
    }

    public boolean canConnectHeat(ForgeDirection side) {
        return this.getReactor() != null;
    }

    public IHeatTransfer getAdjacent(ForgeDirection side) {
        TileEntity adj = Coord4D.get((TileEntity)this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
        if (adj instanceof IHeatTransfer && !(adj instanceof IReactorBlock)) {
            return (IHeatTransfer)adj;
        }
        return null;
    }

    public ItemStack func_70301_a(int slotID) {
        return this.getReactor() != null && this.getReactor().isFormed() ? this.getReactor().getInventory()[slotID] : null;
    }

    public void func_70299_a(int slotID, ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            this.getReactor().getInventory()[slotID] = itemstack;
            if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
                itemstack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (this.getReactor() != null && this.getReactor().isFormed()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = InventoryUtils.EMPTY;
        }
        return nArray;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (this.getReactor() != null && this.getReactor().isFormed() && itemstack.func_77973_b() instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)itemstack.func_77973_b();
            return hohlraum.getGas(itemstack) != null && hohlraum.getGas((ItemStack)itemstack).amount == hohlraum.getMaxGas(itemstack);
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (this.getReactor() != null && this.getReactor().isFormed() && itemstack.func_77973_b() instanceof ItemHohlraum) {
            ItemHohlraum hohlraum = (ItemHohlraum)itemstack.func_77973_b();
            return hohlraum.getGas(itemstack) == null;
        }
        return false;
    }
}

