/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.world.World;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.BossItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldGenerator;

public class RogueBoss
implements WorldFeature {
    public static final BossItem[] items = RogueBoss.buildItems();
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public final double frequency;

    public RogueBoss(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        int y;
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        BossItem item = (BossItem)WorldGenerator.choose(random, totalWeight, items);
        if (item.type == 1) {
            int state = 0;
            for (y = random.nextInt(30) + 12; y > 5; --y) {
                if (world.func_147445_c(x, y, z, true) || world.func_147445_c(x + 1, y, z, true) || world.func_147445_c(x, y, z + 1, true) || world.func_147445_c(x + 1, y, z + 1, true)) {
                    if (state != 0) continue;
                    if (this.canBePlaced(world, random, x, y + 1, z, item)) {
                        this.place(world, random, x, y + 1, z, item);
                        return;
                    }
                    state = -1;
                    continue;
                }
                state = 0;
            }
        } else {
            int state = 0;
            while (y > 5) {
                if (world.func_147445_c(x, y, z, true)) {
                    if (state == 0) {
                        if (this.canBePlaced(world, random, x, y + 1, z, item)) {
                            this.place(world, random, x, y + 1, z, item);
                            return;
                        }
                        state = -1;
                    }
                } else {
                    state = 0;
                }
                --y;
            }
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return this.canBePlaced(world, random, x, y, z, (BossItem)WorldGenerator.choose(random, totalWeight, items));
    }

    public boolean canBePlaced(World world, Random random, int x, int y, int z, BossItem item) {
        return item.type == 1 ? world.func_147437_c(x, y, z) && world.func_147437_c(x + 1, y, z) && world.func_147437_c(x, y, z + 1) && world.func_147437_c(x + 1, y, z + 1) : (item.type == 0 ? world.func_147437_c(x, y, z) : world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z));
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        this.place(world, random, x, y, z, (BossItem)WorldGenerator.choose(random, totalWeight, items));
    }

    public void place(World world, Random random, int x, int y, int z, BossItem item) {
        item.place(world, random, x, y, z);
    }

    private static BossItem[] buildItems() {
        int length = _DeadlyWorld.MOBS.length;
        BossItem[] items = new BossItem[length];
        int i = length;
        while (i-- > 0) {
            items[i] = new BossItem(_DeadlyWorld.MOBS[i], Properties.getInt("bosses_rogue", _DeadlyWorld.MOBS[i].toLowerCase()));
        }
        return items;
    }
}

