/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class SilverNest
implements WorldFeature {
    public static final WorldFeatureItem item = SpawnerItem.buildSpawner("silver_nest", 0);
    public static final WorldFeatureItem angryItem = SpawnerItem.buildSpawner("silver_nest", 1);
    public static final WorldFeatureItem surpriseItem = SpawnerItem.buildSpawner("silver_nest", 2);
    public static final int[] weights = WorldGenerator.getWeights("nests", _DeadlyWorld.NESTS);
    public static final int totalWeight = WorldGenerator.getTotalWeight(weights);
    public static final double angeredChance = Properties.getDouble("nests", "_angered_chance");
    public final double frequency;

    public SilverNest(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        ArrayList<Integer> yValues = new ArrayList<Integer>(15);
        int state = 3;
        for (int y = 62; y > 5; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state > 0) continue;
                if (this.canBePlaced(world, random, x, y + 1, z)) {
                    yValues.add(y + 1);
                }
                state = 3;
                continue;
            }
            state = (byte)(state - 1);
        }
        if (yValues.size() > 0) {
            this.place(world, random, x, (Integer)yValues.get(random.nextInt(yValues.size())), z);
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147437_c(x, y, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        for (int x1 = -1; x1 <= 1; ++x1) {
            for (int y1 = -2; y1 <= 1; ++y1) {
                for (int z1 = -1; z1 <= 1; ++z1) {
                    if (x1 != 0 && z1 != 0 && y1 != -1 && y1 != 0 || x1 == 0 && z1 == 0 && y1 >= -1 && y1 <= 0) continue;
                    world.func_147465_d(x + x1, y + y1, z + z1, Blocks.field_150418_aU, 1, 2);
                }
            }
        }
        if (random.nextDouble() < angeredChance) {
            angryItem.place(world, random, x, y, z);
        } else {
            item.place(world, random, x, y, z);
        }
        String type = WorldGenerator.choose(random, totalWeight, _DeadlyWorld.NESTS, weights);
        if (type == "surprise") {
            surpriseItem.place(world, random, x, y - 1, z);
        } else if (type == "chest") {
            ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.silverfishNestChest");
        } else {
            Block block;
            if (type == "redstone") {
                block = Blocks.field_150450_ax;
            } else if (type == "lapis") {
                block = Blocks.field_150369_x;
            } else if (type == "gold") {
                block = Blocks.field_150352_o;
            } else if (type == "emerald") {
                block = Blocks.field_150412_bA;
            } else if (type == "diamond") {
                block = Blocks.field_150482_ag;
            } else if (type == "party") {
                block = Blocks.field_150414_aQ;
            } else {
                block = Blocks.field_150450_ax;
                _DeadlyWorld.console("Error choosing silvernest type! Unknown type: " + (type == null ? "null" : type));
            }
            world.func_147465_d(x, y - 1, z, block, 0, 2);
        }
    }
}

