/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import toast.deadlyWorld.SpawnBuilder;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class SpawnerItemRandom
extends SpawnerItem {
    public static final int[] weights = WorldGenerator.getWeights("random_spawners", _DeadlyWorld.MOBS);
    public static final int totalWeight = WorldGenerator.getTotalWeight(weights);

    public SpawnerItemRandom(NBTTagCompound tag, int wt, boolean rel, boolean brute) {
        super(tag, wt, rel, brute);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        world.func_147465_d(x, y, z, Blocks.field_150474_ac, 0, 2);
        SpawnBuilder spawner = new SpawnBuilder(world, random, x, y, z);
        if (spawner.isValid) {
            this.copySpawnTag(this.itemTag, spawner.spawnerTag, x, y, z);
            NBTTagCompound data = this.chooseStartingPotential(random, spawner.spawnerTag);
            spawner.setType(data.func_74779_i("Type"));
            spawner.setSpawnData((NBTTagCompound)data.func_74737_b());
            spawner.write();
        }
        world.func_147471_g(x, y, z);
    }

    private NBTTagCompound chooseStartingPotential(Random random, NBTTagCompound spawnerTag) {
        int choice = random.nextInt(totalWeight);
        NBTTagList potentials = spawnerTag.func_150295_c("SpawnPotentials", (int)new NBTTagCompound().func_74732_a());
        int i = weights.length;
        while (i-- > 0) {
            if ((choice -= weights[i]) >= 0) continue;
            return (NBTTagCompound)potentials.func_150305_b(i).func_74737_b();
        }
        _DeadlyWorld.console("Error choosing starting mob for random spawner! " + totalWeight);
        return new NBTTagCompound();
    }
}

