/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class SwarmSpawner
implements WorldFeature {
    public static final WorldFeatureItem[] items = SpawnerItem.buildItems("spawner_swarm");
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public final double frequency;

    public SwarmSpawner(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        int state = 0;
        for (int y = random.nextInt(40) + 11; y > 4; --y) {
            if (world.func_147445_c(x, y, z, true)) {
                if (state != 0) continue;
                if (this.canBePlaced(world, random, x, y + 1, z)) {
                    this.place(world, random, x, y + 1, z);
                    return;
                }
                state = -1;
                continue;
            }
            state = 0;
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && world.func_147437_c(x, y + 1, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.spawnerChestSwarm");
        WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y, z);
        world.func_147465_d(x, y + 1, z, Blocks.field_150322_A, 1, 2);
    }
}

