/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld._DeadlyWorld;
import toast.deadlyWorld.feature.RogueSpawner;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class Tower
implements WorldFeature {
    public static final WorldFeatureItem[] items = new WorldFeatureItem[]{SpawnerItem.buildSpawner("arrow", 0), SpawnerItem.buildSpawner("arrow", 1)};
    public static final int[] weights = WorldGenerator.getWeights("towers", _DeadlyWorld.TOWERS);
    public static final int totalWeight = WorldGenerator.getTotalWeight(weights);
    public final double frequency;

    public Tower(double freq) {
        this.frequency = freq;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        if (this.frequency <= random.nextDouble()) {
            return;
        }
        x += random.nextInt(16);
        z += random.nextInt(16);
        ArrayList<Integer> yValues = new ArrayList<Integer>(15);
        int state = 3;
        for (int y = 62; y > 5; --y) {
            if (!world.func_147437_c(x, y, z)) {
                if (state <= 0 && this.canBePlaced(world, random, x, y + 2, z)) {
                    yValues.add(y + 2);
                }
                state = 3;
                continue;
            }
            state = (byte)(state - 1);
        }
        if (yValues.size() > 0) {
            this.place(world, random, x, (Integer)yValues.get(random.nextInt(yValues.size())), z);
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        for (int x1 = -1; x1 < 2; ++x1) {
            for (int z1 = -1; z1 < 2; ++z1) {
                if (world.func_147437_c(x + x1, y, z + z1)) continue;
                return false;
            }
        }
        return world.func_147437_c(x, y - 1, z);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        Tower.placeTower(world, random, x, y, z);
        y -= 2;
        while (y > 4 && !world.func_147445_c(x, y, z, true)) {
            if (random.nextInt(4) == 0) {
                world.func_147465_d(x, y, z, Blocks.field_150347_e, 0, 2);
            } else {
                world.func_147465_d(x, y, z, Blocks.field_150341_Y, 0, 2);
            }
            world.func_147471_g(x, y, z);
            --y;
        }
    }

    public static void placeTower(World world, Random random, int x, int y, int z) {
        String type = WorldGenerator.choose(random, totalWeight, _DeadlyWorld.TOWERS, weights);
        byte onFire = (byte)(type.endsWith("fire") ? 1 : 0);
        if (type.startsWith("spawner")) {
            WorldGenerator.choose(random, RogueSpawner.totalWeight, RogueSpawner.items).place(world, random, x, y - 1, z);
        } else if (type.startsWith("double")) {
            items[onFire].place(world, random, x, y - 1, z);
        } else if (type.startsWith("chest")) {
            ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.towerChest");
        } else if (random.nextInt(4) == 0) {
            world.func_147465_d(x, y - 1, z, Blocks.field_150347_e, 0, 2);
        } else {
            world.func_147465_d(x, y - 1, z, Blocks.field_150341_Y, 0, 2);
        }
        items[onFire].place(world, random, x, y, z);
    }
}

