/*
 * Decompiled with CFR 0.152.
 */
package toast.deadlyWorld.feature;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import toast.deadlyWorld.ChestBuilder;
import toast.deadlyWorld.Properties;
import toast.deadlyWorld.feature.SpawnerItem;
import toast.deadlyWorld.feature.WorldFeature;
import toast.deadlyWorld.feature.WorldFeatureItem;
import toast.deadlyWorld.feature.WorldGenerator;

public class VeinSpawner
implements WorldFeature {
    public static final WorldFeatureItem[] items = SpawnerItem.buildItems("spawner_vein");
    public static final int totalWeight = WorldGenerator.getTotalWeight(items);
    public static final double armorChance = Properties.getDouble("spawner_veins", "_armor_chance");
    public static final double chestChance = Properties.getDouble("spawner_veins", "_chest_chance");
    public final double veinCount;

    public VeinSpawner(double count) {
        this.veinCount = count;
    }

    @Override
    public void generate(World world, Random random, int x, int z) {
        int chunkX = x;
        int chunkZ = z;
        for (double count = this.veinCount; count >= 1.0 || count > 0.0 && count > random.nextDouble(); count -= 1.0) {
            int y;
            x = chunkX + random.nextInt(16);
            if (!this.canBePlaced(world, random, x, y = random.nextInt(44) + 5, z = chunkZ + random.nextInt(16))) continue;
            this.place(world, random, x, y, z);
        }
    }

    @Override
    public boolean canBePlaced(World world, Random random, int x, int y, int z) {
        return world.func_147445_c(x, y - 1, z, false) && world.func_147445_c(x, y + 1, z, false) && world.func_147445_c(x - 1, y, z, false) && world.func_147445_c(x + 1, y, z, false) && world.func_147445_c(x, y, z - 1, false) && world.func_147445_c(x, y, z + 1, false);
    }

    @Override
    public void place(World world, Random random, int x, int y, int z) {
        if (random.nextDouble() < armorChance) {
            int[][] positions = new int[][]{};
            if (random.nextDouble() < chestChance) {
                positions = new int[][]{{0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {-1, -1, 0}, {1, -1, 0}, {0, -1, -1}, {0, -1, 1}, {0, -2, 0}};
                ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.spawnerChestArmored");
            } else {
                positions = new int[][]{{0, 1, 0}, {-1, 0, 0}, {1, 0, 0}, {0, 0, -1}, {0, 0, 1}, {0, -1, 0}};
            }
            for (int[] pos : positions) {
                world.func_147465_d(x + pos[0], y + pos[1], z + pos[2], Blocks.field_150343_Z, 0, 2);
            }
        } else if (random.nextDouble() < chestChance) {
            ChestBuilder.place(world, random, x, y - 1, z, "DeadlyWorld.spawnerChest");
        }
        WorldGenerator.choose(random, totalWeight, items).place(world, random, x, y, z);
    }
}

