/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.block;

import com.carpentersblocks.block.BlockCoverable;
import com.carpentersblocks.block.BlockSided;
import com.carpentersblocks.data.Button;
import com.carpentersblocks.tileentity.TEBase;
import com.carpentersblocks.util.handler.ChatHandler;
import com.carpentersblocks.util.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentersButton
extends BlockSided {
    private static Button data = new Button();

    public BlockCarpentersButton(Material material) {
        super(material, data);
    }

    @Override
    protected boolean onHammerLeftClick(TEBase TE, EntityPlayer entityPlayer) {
        int polarity = data.getPolarity(TE) == 0 ? 1 : 0;
        data.setPolarity(TE, polarity);
        this.notifyBlocksOfPowerChange(TE.func_145831_w(), TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
        if (polarity == 0) {
            ChatHandler.sendMessageToPlayer("message.polarity_pos.name", entityPlayer);
        } else {
            ChatHandler.sendMessageToPlayer("message.polarity_neg.name", entityPlayer);
        }
        return true;
    }

    @Override
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TEBase TE = this.getTileEntity(blockAccess, x, y, z);
        if (TE != null) {
            this.setBlockBounds(0.3125f, 0.375f, 0.0f, 0.6875f, 0.625f, this.isDepressed(TE) ? 0.0625f : 0.125f, data.getDirection(TE));
        }
    }

    @Override
    protected void postOnBlockActivated(TEBase TE, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ, BlockCoverable.ActionResult actionResult) {
        if (!this.isDepressed(TE)) {
            World world = TE.func_145831_w();
            data.getDirection(TE);
            data.setState(TE, 1, true);
            this.notifyBlocksOfPowerChange(world, TE.field_145851_c, TE.field_145848_d, TE.field_145849_e);
            world.func_147464_a(TE.field_145851_c, TE.field_145848_d, TE.field_145849_e, (Block)this, this.func_149738_a(world));
            actionResult.setAltered();
        }
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block block, int metadata) {
        TEBase TE = this.getSimpleTileEntity((IBlockAccess)world, x, y, z);
        if (TE != null && this.isDepressed(TE)) {
            this.notifyBlocksOfPowerChange(world, x, y, z);
        }
        super.func_149749_a(world, x, y, z, block, metadata);
    }

    private boolean isDepressed(TEBase TE) {
        return data.getState(TE) == 1;
    }

    @Override
    public int getPowerOutput(TEBase TE) {
        int polarity = data.getPolarity(TE);
        if (this.isDepressed(TE)) {
            return polarity == 0 ? 15 : 0;
        }
        return polarity == 1 ? 15 : 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        TEBase TE;
        if (!world.field_72995_K && (TE = this.getTileEntity((IBlockAccess)world, x, y, z)) != null) {
            data.setState(TE, 0, true);
            this.notifyBlocksOfPowerChange(world, x, y, z);
        }
    }

    public int func_149645_b() {
        return BlockRegistry.carpentersButtonRenderID;
    }
}

