/*
 * Decompiled with CFR 0.152.
 */
package com.carpentersblocks.renderer;

import com.carpentersblocks.renderer.BlockHandlerSloped;
import com.carpentersblocks.renderer.helper.RenderHelper;
import com.carpentersblocks.renderer.helper.RenderHelperCollapsible;
import com.carpentersblocks.renderer.helper.VertexHelper;
import com.carpentersblocks.util.collapsible.CollapsibleUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

@SideOnly(value=Side.CLIENT)
public class BlockHandlerCarpentersCollapsibleBlock
extends BlockHandlerSloped {
    private static final int NORMAL_YN = 0;
    private static final int NORMAL_ZN = 1;
    private static final int NORMAL_ZP = 2;
    private static final int NORMAL_XN = 3;
    private static final int NORMAL_XP = 4;
    private static final int SLOPE_YZPN = 5;
    private static final int SLOPE_YZPP = 6;
    private static final int SLOPE_XYNP = 7;
    private static final int SLOPE_XYPP = 8;

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderBlocks) {
        renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        super.renderInventoryBlock(block, metadata, modelID, renderBlocks);
    }

    @Override
    protected void renderBaseSide(int x, int y, int z, int side, IIcon icon) {
        switch (this.renderID) {
            case 0: {
                RenderHelper.renderFaceYNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 1: {
                RenderHelperCollapsible.renderFaceZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 2: {
                RenderHelperCollapsible.renderFaceZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 3: {
                RenderHelperCollapsible.renderFaceXNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 4: {
                RenderHelperCollapsible.renderFaceXPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 5: {
                RenderHelperCollapsible.renderSlopeYPosZNeg(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 6: {
                RenderHelperCollapsible.renderSlopeYPosZPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 7: {
                RenderHelperCollapsible.renderSlopeXNegYPos(this.renderBlocks, x, y, z, icon);
                break;
            }
            case 8: {
                RenderHelperCollapsible.renderSlopeXPosYPos(this.renderBlocks, x, y, z, icon);
            }
        }
    }

    @Override
    protected void renderBaseBlock(ItemStack itemStack, int x, int y, int z) {
        this.renderBlocks.field_147863_w = this.getEnableAO(itemStack);
        CollapsibleUtil.computeOffsets(this.TE);
        if (this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y + 1, z, 1) || !CollapsibleUtil.isFullHeight(this.TE)) {
            VertexHelper.startDrawing(4);
            isSideSloped = true;
            this.prepareTopFace(itemStack, x, y, z);
            isSideSloped = false;
        }
        VertexHelper.startDrawing(7);
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.prepareLighting(itemStack);
        if (this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y - 1, z, 0)) {
            this.lightingHelper.setupLightingYNeg(itemStack, x, y, z);
            this.setIDAndRender(itemStack, 0, x, y, z, 0);
        }
        double oneStep = 0.06666666666666667;
        if (this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y, z - 1, 2) && CollapsibleUtil.offset_XZNN + CollapsibleUtil.offset_XZPN >= oneStep) {
            this.prepareFaceZNeg(itemStack, x, y, z);
        }
        if (this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x, y, z + 1, 3) && CollapsibleUtil.offset_XZNP + CollapsibleUtil.offset_XZPP >= oneStep) {
            this.prepareFaceZPos(itemStack, x, y, z);
        }
        if (this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x - 1, y, z, 4) && CollapsibleUtil.offset_XZNN + CollapsibleUtil.offset_XZNP >= oneStep) {
            this.prepareFaceXNeg(itemStack, x, y, z);
        }
        if (this.srcBlock.func_149646_a((IBlockAccess)this.TE.func_145831_w(), x + 1, y, z, 5) && CollapsibleUtil.offset_XZPN + CollapsibleUtil.offset_XZPP >= oneStep) {
            this.prepareFaceXPos(itemStack, x, y, z);
        }
        this.renderBlocks.field_147863_w = false;
    }

    private float getInterpolatedLightness(ForgeDirection side) {
        switch (side) {
            case NORTH: {
                double lightness_WE = (double)(1.0f - this.lightingHelper.LIGHTNESS[4]) * Math.abs(CollapsibleUtil.offset_XZNN - CollapsibleUtil.offset_XZPN);
                double lightness_NS = (double)(1.0f - this.lightingHelper.LIGHTNESS[2]) * Math.abs(CollapsibleUtil.CENTER_YMAX - (CollapsibleUtil.offset_XZPN + CollapsibleUtil.offset_XZNN) / 2.0) * 2.0;
                return (float)((double)this.lightingHelper.LIGHTNESS[1] - (lightness_WE + lightness_NS) / 2.0);
            }
            case SOUTH: {
                double lightness_WE = (double)(1.0f - this.lightingHelper.LIGHTNESS[4]) * Math.abs(CollapsibleUtil.offset_XZNP - CollapsibleUtil.offset_XZPP);
                double lightness_NS = (double)(1.0f - this.lightingHelper.LIGHTNESS[2]) * Math.abs(CollapsibleUtil.CENTER_YMAX - (CollapsibleUtil.offset_XZPP + CollapsibleUtil.offset_XZNP) / 2.0) * 2.0;
                return (float)((double)this.lightingHelper.LIGHTNESS[1] - (lightness_WE + lightness_NS) / 2.0);
            }
            case WEST: {
                double lightness_WE = (double)(1.0f - this.lightingHelper.LIGHTNESS[2]) * Math.abs(CollapsibleUtil.offset_XZNN - CollapsibleUtil.offset_XZNP);
                double lightness_NS = (double)(1.0f - this.lightingHelper.LIGHTNESS[4]) * Math.abs(CollapsibleUtil.CENTER_YMAX - (CollapsibleUtil.offset_XZNP + CollapsibleUtil.offset_XZNN) / 2.0) * 2.0;
                return (float)((double)this.lightingHelper.LIGHTNESS[1] - (lightness_WE + lightness_NS) / 2.0);
            }
            case EAST: {
                double lightness_WE = (double)(1.0f - this.lightingHelper.LIGHTNESS[2]) * Math.abs(CollapsibleUtil.offset_XZPP - CollapsibleUtil.offset_XZPN);
                double lightness_NS = (double)(1.0f - this.lightingHelper.LIGHTNESS[4]) * Math.abs(CollapsibleUtil.CENTER_YMAX - (CollapsibleUtil.offset_XZPP + CollapsibleUtil.offset_XZPN) / 2.0) * 2.0;
                return (float)((double)this.lightingHelper.LIGHTNESS[1] - (lightness_WE + lightness_NS) / 2.0);
            }
        }
        return 1.0f;
    }

    private void prepareTopFace(ItemStack itemStack, int x, int y, int z) {
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 0.5, CollapsibleUtil.CENTER_YMAX, 0.5);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        float aoCenter = this.lightingHelper.ao[0];
        int brightnessCenter = this.renderBlocks.field_147864_al;
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, CollapsibleUtil.offset_XZPP, 1.0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        float aoXZPP = this.lightingHelper.ao[0];
        int brightnessXZPP = this.renderBlocks.field_147864_al;
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, CollapsibleUtil.offset_XZPN, 1.0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        float aoXZPN = this.lightingHelper.ao[1];
        int brightnessXZPN = this.renderBlocks.field_147874_am;
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, CollapsibleUtil.offset_XZNN, 1.0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        float aoXZNN = this.lightingHelper.ao[2];
        int brightnessXZNN = this.renderBlocks.field_147876_an;
        this.renderBlocks.func_147782_a(0.0, 0.0, 0.0, 1.0, CollapsibleUtil.offset_XZNP, 1.0);
        this.lightingHelper.setupLightingYPos(itemStack, x, y, z);
        float aoXZNP = this.lightingHelper.ao[3];
        int brightnessXZNP = this.renderBlocks.field_147870_ao;
        this.lightingHelper.setLightnessOverride(this.getInterpolatedLightness(ForgeDirection.NORTH));
        this.renderBlocks.func_147782_a(0.0, Math.min(CollapsibleUtil.offset_XZNN, CollapsibleUtil.offset_XZPN), 0.0, 1.0, Math.max(CollapsibleUtil.offset_XZNN, CollapsibleUtil.offset_XZPN), 0.5);
        this.lightingHelper.ao[0] = this.lightingHelper.ao[3] = aoCenter;
        this.renderBlocks.field_147864_al = this.renderBlocks.field_147870_ao = brightnessCenter;
        this.lightingHelper.ao[1] = aoXZPN;
        this.renderBlocks.field_147874_am = brightnessXZPN;
        this.lightingHelper.ao[2] = aoXZNN;
        this.renderBlocks.field_147876_an = brightnessXZNN;
        this.setIDAndRender(itemStack, 5, x, y, z, 1);
        this.lightingHelper.setLightnessOverride(this.getInterpolatedLightness(ForgeDirection.SOUTH));
        this.renderBlocks.func_147782_a(0.0, Math.min(CollapsibleUtil.offset_XZNP, CollapsibleUtil.offset_XZPP), 0.5, 1.0, Math.max(CollapsibleUtil.offset_XZNP, CollapsibleUtil.offset_XZPP), 1.0);
        this.lightingHelper.ao[1] = this.lightingHelper.ao[2] = aoCenter;
        this.renderBlocks.field_147874_am = this.renderBlocks.field_147876_an = brightnessCenter;
        this.lightingHelper.ao[0] = aoXZPP;
        this.renderBlocks.field_147864_al = brightnessXZPP;
        this.lightingHelper.ao[3] = aoXZNP;
        this.renderBlocks.field_147870_ao = brightnessXZNP;
        this.setIDAndRender(itemStack, 6, x, y, z, 1);
        this.lightingHelper.setLightnessOverride(this.getInterpolatedLightness(ForgeDirection.WEST));
        this.renderBlocks.func_147782_a(0.0, Math.min(CollapsibleUtil.offset_XZNN, CollapsibleUtil.offset_XZNP), 0.0, 0.5, Math.max(CollapsibleUtil.offset_XZNN, CollapsibleUtil.offset_XZNP), 1.0);
        this.lightingHelper.ao[0] = this.lightingHelper.ao[1] = aoCenter;
        this.renderBlocks.field_147864_al = this.renderBlocks.field_147874_am = brightnessCenter;
        this.lightingHelper.ao[3] = aoXZNP;
        this.renderBlocks.field_147870_ao = brightnessXZNP;
        this.lightingHelper.ao[2] = aoXZNN;
        this.renderBlocks.field_147876_an = brightnessXZNN;
        this.setIDAndRender(itemStack, 7, x, y, z, 1);
        this.lightingHelper.setLightnessOverride(this.getInterpolatedLightness(ForgeDirection.EAST));
        this.renderBlocks.func_147782_a(0.5, Math.min(CollapsibleUtil.offset_XZPN, CollapsibleUtil.offset_XZPP), 0.0, 1.0, Math.max(CollapsibleUtil.offset_XZPN, CollapsibleUtil.offset_XZPP), 1.0);
        this.lightingHelper.ao[3] = this.lightingHelper.ao[2] = aoCenter;
        this.renderBlocks.field_147870_ao = this.renderBlocks.field_147876_an = brightnessCenter;
        this.lightingHelper.ao[0] = aoXZPP;
        this.renderBlocks.field_147864_al = brightnessXZPP;
        this.lightingHelper.ao[1] = aoXZPN;
        this.renderBlocks.field_147874_am = brightnessXZPN;
        this.setIDAndRender(itemStack, 8, x, y, z, 1);
        this.lightingHelper.clearLightnessOverride();
    }

    private void prepareFaceZNeg(ItemStack itemStack, int x, int y, int z) {
        this.lightingHelper.setupLightingZNeg(itemStack, x, y, z);
        if (this.renderBlocks.field_147863_w) {
            this.lightingHelper.ao[0] = (float)((double)this.ao[2][1] + (double)(this.ao[2][0] - this.ao[2][1]) * CollapsibleUtil.offset_XZPN);
            this.lightingHelper.ao[3] = (float)((double)this.ao[2][2] + (double)(this.ao[2][3] - this.ao[2][2]) * CollapsibleUtil.offset_XZNN);
        }
        this.setIDAndRender(itemStack, 1, x, y, z, 2);
    }

    private void prepareFaceZPos(ItemStack itemStack, int x, int y, int z) {
        this.lightingHelper.setupLightingZPos(itemStack, x, y, z);
        if (this.renderBlocks.field_147863_w) {
            this.lightingHelper.ao[0] = (float)((double)this.ao[3][1] + (double)(this.ao[3][0] - this.ao[3][1]) * CollapsibleUtil.offset_XZNP);
            this.lightingHelper.ao[3] = (float)((double)this.ao[3][2] + (double)(this.ao[3][3] - this.ao[3][2]) * CollapsibleUtil.offset_XZPP);
        }
        this.setIDAndRender(itemStack, 2, x, y, z, 3);
    }

    private void prepareFaceXNeg(ItemStack itemStack, int x, int y, int z) {
        this.lightingHelper.setupLightingXNeg(itemStack, x, y, z);
        if (this.renderBlocks.field_147863_w) {
            this.lightingHelper.ao[0] = (float)((double)this.ao[4][1] + (double)(this.ao[4][0] - this.ao[4][1]) * CollapsibleUtil.offset_XZNN);
            this.lightingHelper.ao[3] = (float)((double)this.ao[4][2] + (double)(this.ao[4][3] - this.ao[4][2]) * CollapsibleUtil.offset_XZNP);
        }
        this.setIDAndRender(itemStack, 3, x, y, z, 4);
    }

    private void prepareFaceXPos(ItemStack itemStack, int x, int y, int z) {
        this.lightingHelper.setupLightingXPos(itemStack, x, y, z);
        if (this.renderBlocks.field_147863_w) {
            this.lightingHelper.ao[0] = (float)((double)this.ao[5][1] + (double)(this.ao[5][0] - this.ao[5][1]) * CollapsibleUtil.offset_XZPP);
            this.lightingHelper.ao[3] = (float)((double)this.ao[5][2] + (double)(this.ao[5][3] - this.ao[5][2]) * CollapsibleUtil.offset_XZPN);
        }
        this.setIDAndRender(itemStack, 4, x, y, z, 5);
    }
}

