/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.EnderZooTab;
import crazypants.enderzoo.config.Config;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemGuardiansBow
extends ItemBow {
    private static final String NAME = "guardiansBow";
    public static final String[] bowPullIconNameArray = new String[]{"pulling_0", "pulling_1", "pulling_2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private int drawTime = Config.guardiansBowDrawTime;
    private float damageBonus = Config.guardiansBowDamageBonus;
    private float forceMultiplier = Config.guardiansBowForceMultiplier;
    private float fovMultiplier = Config.guardiansBowFovMultiplier;

    public static ItemGuardiansBow create() {
        ItemGuardiansBow res = new ItemGuardiansBow();
        res.init();
        MinecraftForge.EVENT_BUS.register((Object)res);
        return res;
    }

    protected ItemGuardiansBow() {
        this.func_77655_b(NAME);
        this.func_77637_a(EnderZooTab.tabEnderZoo);
        this.func_111206_d("enderzoo:guardiansBow");
        this.func_77656_e(800);
        this.func_77627_a(false);
    }

    protected void init() {
        GameRegistry.registerItem((Item)this, (String)NAME);
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int itemInUseCount) {
        boolean infiniteArrows;
        int drawDuration = this.func_77626_a(stack) - itemInUseCount;
        boolean bl = infiniteArrows = player.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((int)Enchantment.field_77342_w.field_77352_x, (ItemStack)stack) > 0;
        if (infiniteArrows || player.field_71071_by.func_146028_b(Items.field_151032_g)) {
            int punchLevel;
            float force = (float)drawDuration / (float)this.drawTime;
            if ((double)(force = (force * force + force * 2.0f) / 3.0f) < 0.2) {
                return;
            }
            if (force > 1.0f) {
                force = 1.0f;
            }
            EntityArrow entityarrow = new EntityArrow(world, (EntityLivingBase)player, force * this.forceMultiplier);
            if (force == 1.0f) {
                entityarrow.func_70243_d(true);
            }
            entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)this.damageBonus);
            int powerLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)stack);
            if (powerLevel > 0) {
                entityarrow.func_70239_b(entityarrow.func_70242_d() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)stack)) > 0) {
                entityarrow.func_70240_a(punchLevel);
            }
            if (EnchantmentHelper.func_77506_a((int)Enchantment.field_77343_v.field_77352_x, (ItemStack)stack) > 0) {
                entityarrow.func_70015_d(100);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + force * 0.5f);
            if (infiniteArrows) {
                entityarrow.field_70251_a = 2;
            } else {
                player.field_71071_by.func_146026_a(Items.field_151032_g);
            }
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityarrow);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFovUpdateEvent(FOVUpdateEvent fovEvt) {
        ItemStack currentItem = fovEvt.entity.func_71045_bC();
        if (currentItem == null || currentItem.func_77973_b() != this || fovEvt.entity.func_71052_bv() <= 0) {
            return;
        }
        int drawDuration = this.func_77626_a(currentItem) - fovEvt.entity.func_71052_bv();
        float ratio = (float)drawDuration / (float)this.drawTime;
        ratio = ratio > 1.0f ? 1.0f : (ratio *= ratio);
        fovEvt.newfov = 1.0f - ratio * this.fovMultiplier;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int useTime = stack.func_77988_m() - useRemaining;
        IIcon iicon = this.field_77791_bV;
        if (usingItem == null) {
            return iicon;
        }
        if (useTime >= this.drawTime - 2) {
            iicon = EnderZoo.itemGuardiansBow.func_94599_c(2);
        } else if ((float)useTime > (float)(this.drawTime * 2) / 3.0f) {
            iicon = EnderZoo.itemGuardiansBow.func_94599_c(1);
        } else if (useTime > 0) {
            iicon = EnderZoo.itemGuardiansBow.func_94599_c(0);
        }
        return iicon;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b(Items.field_151032_g)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public int func_77619_b() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister p_94581_1_) {
        this.field_77791_bV = p_94581_1_.func_94245_a(this.func_111208_A() + "_standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = p_94581_1_.func_94245_a(this.func_111208_A() + "_" + bowPullIconNameArray[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_94599_c(int useDuration) {
        return this.iconArray[useDuration];
    }
}

