/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.spawn;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityDireSlime;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.spawn.ISpawnEntry;
import crazypants.enderzoo.spawn.MobSpawns;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BlockEvent;

public class MobSpawnEventHandler {
    private static final String APPLIED_KEY = "ezModsApp";
    private static List<EntityLivingBase> toApplyEZ = new ArrayList<EntityLivingBase>();
    private static List<EntityLivingBase> toApplyOthers = new ArrayList<EntityLivingBase>();
    private Map<EnumDifficulty, Double> ezHealthMods = new HashMap<EnumDifficulty, Double>();
    private Map<EnumDifficulty, Double> ezAttackMods = new HashMap<EnumDifficulty, Double>();
    private Map<EnumDifficulty, Double> otherHealthMods = new HashMap<EnumDifficulty, Double>();
    private Map<EnumDifficulty, Double> otherAttackMods = new HashMap<EnumDifficulty, Double>();

    public MobSpawnEventHandler() {
        this.ezHealthMods.put(EnumDifficulty.PEACEFUL, 1.0);
        this.ezHealthMods.put(EnumDifficulty.EASY, Config.enderZooEasyHealthModifier);
        this.ezHealthMods.put(EnumDifficulty.NORMAL, Config.enderZooNormalHealthModifier);
        this.ezHealthMods.put(EnumDifficulty.HARD, Config.enderZooHardHealthModifier);
        this.ezAttackMods.put(EnumDifficulty.PEACEFUL, 1.0);
        this.ezAttackMods.put(EnumDifficulty.EASY, Config.enderZooEasyAttackModifier);
        this.ezAttackMods.put(EnumDifficulty.NORMAL, Config.enderZooNormalAttackModifier);
        this.ezAttackMods.put(EnumDifficulty.HARD, Config.enderZooHardAttackModifier);
        this.otherHealthMods.put(EnumDifficulty.PEACEFUL, 1.0);
        this.otherHealthMods.put(EnumDifficulty.EASY, Config.globalEasyHealthModifier);
        this.otherHealthMods.put(EnumDifficulty.NORMAL, Config.globalNormalHealthModifier);
        this.otherHealthMods.put(EnumDifficulty.HARD, Config.globalHardHealthModifier);
        this.otherAttackMods.put(EnumDifficulty.PEACEFUL, 1.0);
        this.otherAttackMods.put(EnumDifficulty.EASY, Config.globalEasyAttackModifier);
        this.otherAttackMods.put(EnumDifficulty.NORMAL, Config.globalNormalAttackModifier);
        this.otherAttackMods.put(EnumDifficulty.HARD, Config.globalHardAttackModifier);
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.entityLiving == null) {
            return;
        }
        String name = EntityList.func_75621_b((Entity)evt.entityLiving);
        if (name == null) {
            return;
        }
        for (ISpawnEntry ent : MobSpawns.instance.getEntries()) {
            if (!name.equals(ent.getMobName()) || ent.canSpawnInDimension(evt.world)) continue;
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent evt) {
        EntityLivingBase ent;
        if (evt.world == null || evt.world.field_72995_K) {
            return;
        }
        if (Config.enderZooDifficultyModifierEnabled && evt.entity instanceof IEnderZooMob) {
            EntityLivingBase ent2 = (EntityLivingBase)evt.entity;
            if (!ent2.getEntityData().func_74767_n(APPLIED_KEY)) {
                toApplyEZ.add(ent2);
            }
        } else if (Config.globalDifficultyModifierEnabled && evt.entity instanceof IMob && evt.entity instanceof EntityLivingBase && !(ent = (EntityLivingBase)evt.entity).getEntityData().func_74767_n(APPLIED_KEY)) {
            toApplyOthers.add(ent);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        for (EntityLivingBase ent : toApplyEZ) {
            if (ent.field_70128_L || ent.field_70170_p == null) continue;
            this.applyEnderZooModifiers(ent, ent.field_70170_p);
            ent.getEntityData().func_74757_a(APPLIED_KEY, true);
        }
        toApplyEZ.clear();
        for (EntityLivingBase ent : toApplyOthers) {
            if (ent.field_70128_L || ent.field_70170_p == null) continue;
            this.applyGloablModifiers(ent, ent.field_70170_p);
            ent.getEntityData().func_74757_a(APPLIED_KEY, true);
        }
        toApplyOthers.clear();
    }

    private void applyGloablModifiers(EntityLivingBase entity, World world) {
        if (world == null || world.field_73013_u == null) {
            return;
        }
        double attackModifier = this.otherAttackMods.get(world.field_73013_u);
        double healthModifier = this.otherHealthMods.get(world.field_73013_u);
        if (attackModifier != 1.0) {
            this.adjustBaseAttack(entity, attackModifier);
        }
        if (healthModifier != 1.0) {
            this.addjustBaseHealth(entity, healthModifier);
        }
    }

    private void applyEnderZooModifiers(EntityLivingBase entity, World world) {
        if (world == null || world.field_73013_u == null) {
            return;
        }
        double attackModifier = this.ezAttackMods.get(world.field_73013_u);
        double healthModifier = this.ezHealthMods.get(world.field_73013_u);
        if (attackModifier != 1.0) {
            this.adjustBaseAttack(entity, attackModifier);
        }
        if (healthModifier != 1.0) {
            this.addjustBaseHealth(entity, healthModifier);
        }
    }

    protected void addjustBaseHealth(EntityLivingBase ent, double healthModifier) {
        IAttributeInstance att = ent.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        if (att == null) {
            return;
        }
        double curValue = att.func_111125_b();
        double newValue = curValue * healthModifier / 2.0;
        newValue = healthModifier >= 1.0 ? Math.ceil(newValue) : Math.floor(newValue);
        if ((newValue = Math.floor(newValue * 2.0)) < 2.0) {
            newValue = curValue;
        }
        att.func_111128_a(newValue);
        ent.func_70606_j((float)newValue);
    }

    protected void adjustBaseAttack(EntityLivingBase ent, double attackModifier) {
        IAttributeInstance att = ent.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        if (att == null) {
            return;
        }
        double curValue = att.func_111125_b();
        double newValue = curValue * attackModifier;
        att.func_111128_a(newValue);
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (Config.direSlimeEnabled && !event.isCanceled() && (event.block instanceof BlockDirt || event.block instanceof BlockGrass) && event.harvester != null && !event.harvester.field_71075_bZ.field_75098_d && event.world != null && !event.world.field_72995_K && event.harvester.func_71045_bC() != null && !ForgeHooks.isToolEffective((ItemStack)event.harvester.func_71045_bC(), (Block)event.block, (int)event.blockMetadata) && Config.direSlimeChance >= (double)event.world.field_73012_v.nextFloat()) {
            EntityDireSlime direSlime = new EntityDireSlime(event.world);
            direSlime.func_70107_b((double)event.x + 0.5, (double)event.y + 0.0, (double)event.z + 0.5);
            event.world.func_72838_d((Entity)direSlime);
            direSlime.func_70642_aH();
            for (ItemStack drop : event.drops) {
                if (drop == null || drop.func_77973_b() == null || drop.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d)) continue;
                if (drop.field_77994_a > 1) {
                    --drop.field_77994_a;
                } else if (event.drops.size() == 1) {
                    event.drops.clear();
                } else {
                    event.drops.remove(drop);
                }
                return;
            }
        }
    }
}

