/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.quests.QuestTaskReputation;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationMarker;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;

public class GuiEditMenuReputationSetting
extends GuiEditMenuExtended {
    private Reputation reputation;
    private int reputationId;
    private ReputationMarker lower;
    private ReputationMarker upper;
    private boolean inverted;
    private QuestTaskReputation task;
    private int id;
    private static final int BARS_X = 20;
    private static final int LOWER_Y = 50;
    private static final int UPPER_Y = 90;
    private static final int RESULT_Y = 150;
    private static final int BAR_OFFSET_Y = 10;

    public GuiEditMenuReputationSetting(GuiQuestBook gui, EntityPlayer player, QuestTaskReputation task, int id, QuestTaskReputation.ReputationSetting setting) {
        super(gui, player, true, 25, 25, -1, -1);
        this.task = task;
        this.id = id;
        if (setting == null || setting.getReputation() == null) {
            if (!Reputation.getReputationList().isEmpty()) {
                this.reputation = Reputation.getReputationList().get(0);
                this.reputationId = 0;
            } else {
                this.reputationId = -1;
            }
        } else {
            this.reputation = setting.getReputation();
            id = -1;
            List<Reputation> reputationList = Reputation.getReputationList();
            for (int i = 0; i < reputationList.size(); ++i) {
                Reputation element = reputationList.get(i);
                if (!element.equals(this.reputation)) continue;
                id = i;
                break;
            }
            if (id == -1) {
                this.reputation = null;
            } else {
                this.lower = setting.getLower();
                this.upper = setting.getUpper();
                this.inverted = setting.isInverted();
            }
        }
        this.checkboxes.add(new GuiEditMenu.CheckBox("Inverted range?", 21, 124){

            @Override
            public boolean getValue() {
                return GuiEditMenuReputationSetting.this.inverted;
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuReputationSetting.this.inverted = val;
            }

            @Override
            protected boolean isVisible() {
                return GuiEditMenuReputationSetting.this.reputation != null;
            }
        });
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        if (this.reputation != null) {
            String info = null;
            gui.drawString("Lower bounds", 20, 50, 0x404040);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.draw((GuiQuestBook)gui, 20, 60, mX, mY, info, this.player, false, null, null, false, this.lower, this.lower == null ? "" : "Selected: " + this.lower.getLabel(), false);
            gui.drawString("Upper bounds", 20, 90, 0x404040);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.draw((GuiQuestBook)gui, 20, 100, mX, mY, info, this.player, false, null, null, false, this.upper, this.upper == null ? "" : "Selected: " + this.upper.getLabel(), false);
            gui.drawString("Preview", 20, 150, 0x404040);
            gui.applyColor(-1);
            ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
            info = this.reputation.draw((GuiQuestBook)gui, 20, 160, mX, mY, info, this.player, true, this.lower, this.upper, this.inverted, null, null, false);
            if (info != null) {
                gui.drawMouseOver(info, mX + gui.getLeft(), mY + gui.getTop());
            }
        }
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int b) {
        super.onClick(gui, mX, mY, b);
        if (this.reputation != null) {
            ReputationMarker marker = this.reputation.onActiveClick((GuiQuestBook)gui, 20, 60, mX, mY);
            if (marker != null) {
                this.lower = marker.equals(this.lower) ? null : marker;
            } else {
                marker = this.reputation.onActiveClick((GuiQuestBook)gui, 20, 100, mX, mY);
                if (marker != null) {
                    this.upper = marker.equals(this.upper) ? null : marker;
                }
            }
        }
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (this.reputation != null) {
            this.reputationId += left ? -1 : 1;
            if (this.reputationId < 0) {
                this.reputationId = Reputation.getReputationList().size() - 1;
            } else if (this.reputationId >= Reputation.getReputationList().size()) {
                this.reputationId = 0;
            }
            this.lower = null;
            this.upper = null;
            this.reputation = Reputation.getReputationList().get(this.reputationId);
        }
    }

    @Override
    protected String getArrowText() {
        if (Reputation.getReputationList().isEmpty()) {
            return "Invalid";
        }
        return this.reputation.getName();
    }

    @Override
    protected String getArrowDescription() {
        if (Reputation.getReputationList().isEmpty()) {
            return "There are no valid reputations to choose from. Please go to the reputation menu (click on the reputation button on the left hand side of the book when browsing the main menu) and create at least one first.";
        }
        return null;
    }

    @Override
    protected void save(GuiBase gui) {
        if (this.reputation != null) {
            this.task.setSetting(this.id, new QuestTaskReputation.ReputationSetting(this.reputation, this.lower, this.upper, this.inverted));
        }
    }
}

