/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.DeathType;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.QuestingData;
import hardcorequesting.Util;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.config.ModConfig;
import hardcorequesting.items.ItemInfo;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemHeart
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    public static final String[] names = ItemInfo.HEART_ICONS;
    private String line;

    public ItemHeart() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77637_a(HardcoreQuesting.HQMTab);
        this.func_77655_b("hqm:hearts");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.pickIcon(icon);
    }

    private void pickIcon(IIconRegister icon) {
        this.icons = new IIcon[ItemInfo.HEART_ICONS.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = icon.func_94245_a("hqm:" + ItemInfo.HEART_ICONS[i]);
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77960_j(), (int)0, (int)15);
        return super.func_77658_a() + "_" + names[i];
    }

    public IIcon func_77617_a(int par1) {
        return this.icons[par1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List par3List) {
        for (int x = 0; x < ItemInfo.HEART_ICONS.length; ++x) {
            par3List.add(new ItemStack((Item)this, 1, x));
        }
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (item.func_77960_j() == 3) {
                if (!QuestingData.isHardcoreActive()) {
                    this.line = "Hardcore Mode isn't enabled yet. use '/hqm hardcore' to enable it.";
                    player.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                } else if (QuestingData.getQuestingData(player).getRawLives() < ModConfig.MAXLIVES) {
                    QuestingData.getQuestingData(player).addLives(player, 1);
                    this.line = "You have added 1 to your total life.";
                    player.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                    int lives = QuestingData.getQuestingData(player).getLives();
                    this.line = "You have " + lives + " remaining.";
                    player.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                    SoundHandler.play(Sounds.LIFE, player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --item.field_77994_a;
                    }
                } else {
                    this.line = "You already have maximum lives.";
                    player.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                }
            }
            if (item.func_77960_j() == 4) {
                if (!QuestingData.isHardcoreActive()) {
                    this.line = "Hardcore Mode isn't enabled yet. use '/hqm hardcore' to enable it.";
                    player.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                } else {
                    SoundHandler.play(Sounds.ROTTEN, player);
                    this.line = "Why did you eat a rotten heart?";
                    player.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                    QuestingData.getQuestingData(player).removeLifeAndSendMessage(player);
                    DeathType.HQM.onDeath(player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --item.field_77994_a;
                    }
                }
            }
            return item;
        }
        return item;
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List lst, boolean extraInfo) {
        super.func_77624_a(item, player, lst, extraInfo);
        if (item.func_77960_j() == 3) {
            lst.add("Consume to get an extra life");
            if (ModConfig.ROTTIMER) {
                NBTTagCompound tagCompound = item.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    item.func_77982_d(tagCompound);
                }
                if (tagCompound.func_74764_b("RotTime")) {
                    int rot = tagCompound.func_74762_e("RotTime");
                    int maxRot = tagCompound.func_74762_e("MaxRot");
                    float percentage = rot * 100 / maxRot;
                    lst.add("Current freshness : " + percentage + " %");
                }
            }
        }
        if (item.func_77960_j() == 4) {
            lst.add("Rotten Heart. Do Not Eat");
        }
    }

    public boolean hasEffect(ItemStack item, int pass) {
        return item.func_77960_j() == 3 || item.func_77960_j() == 4;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (itemStack.func_77960_j() == 3 && ModConfig.ROTTIMER) {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    itemStack.func_77982_d(tagCompound);
                }
                if (!tagCompound.func_74764_b("RotTime")) {
                    int rot = ModConfig.MAXROT * 20;
                    tagCompound.func_74768_a("MaxRot", rot);
                    tagCompound.func_74768_a("RotTime", rot);
                } else {
                    int newRot = tagCompound.func_74762_e("RotTime");
                    if (newRot <= 0) {
                        itemStack.func_77964_b(4);
                        this.line = "One or more of your hearts has just decade into a Rotten Heart.";
                        entityPlayer.func_146105_b((IChatComponent)Util.getChatComponent(this.line, EnumChatFormatting.WHITE));
                    } else {
                        tagCompound.func_74768_a("RotTime", newRot - 1);
                    }
                }
            }
        }
    }
}

