/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.network.DataBitHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class DataWriter {
    private OutputStream stream;
    private int byteBuffer;
    private int bitCountBuffer;
    private int bits;
    private static final int MAX_PACKET_SIZE = 32766;
    private DataBitHelper bufferSize;
    private DataWriter buffer;

    DataWriter() {
        this.stream = new ByteArrayOutputStream();
    }

    DataWriter(OutputStream stream) {
        this.stream = stream;
    }

    public void writeByte(int data) {
        this.writeData(data, DataBitHelper.BYTE);
    }

    public void writeBoolean(boolean data) {
        this.writeData(data ? 1 : 0, DataBitHelper.BOOLEAN);
    }

    public void writeData(int data, DataBitHelper bitCount) {
        this.writeData(data, bitCount.getBitCount());
    }

    public void writeData(int data, int bitCount) {
        if (this.buffer != null) {
            this.buffer.writeData(data, bitCount);
            return;
        }
        this.bits += bitCount;
        long mask = (long)Math.pow(2.0, bitCount) - 1L;
        data = (int)((long)data & mask);
        while (this.bitCountBuffer + bitCount >= 8) {
            int bitsToAdd = 8 - this.bitCountBuffer;
            int addMask = (int)Math.pow(2.0, bitsToAdd) - 1;
            int addData = data & addMask;
            data >>>= bitsToAdd;
            this.byteBuffer |= (addData <<= this.bitCountBuffer);
            try {
                this.stream.write(this.byteBuffer);
            }
            catch (IOException ignored) {
                // empty catch block
            }
            this.byteBuffer = 0;
            bitCount -= bitsToAdd;
            this.bitCountBuffer = 0;
        }
        this.byteBuffer |= data << this.bitCountBuffer;
        this.bitCountBuffer += bitCount;
    }

    void close() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeString(String str, DataBitHelper bits) {
        if (str != null) {
            byte[] bytes = str.getBytes();
            int l = Math.min(bytes.length, bits.getMaximum());
            this.writeData(l, bits);
            for (int i = 0; i < l; ++i) {
                this.writeByte(bytes[i]);
            }
        } else {
            this.writeData(0, bits);
        }
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        byte[] bytes = null;
        if (nbtTagCompound != null) {
            try {
                bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)nbtTagCompound);
            }
            catch (IOException ex) {
                bytes = null;
            }
        }
        this.writeBoolean(bytes != null);
        if (bytes != null) {
            this.writeData(bytes.length, DataBitHelper.NBT_LENGTH);
            for (byte b : bytes) {
                this.writeByte(b);
            }
        }
    }

    void sendToPlayer(EntityPlayerMP player) {
        this.writeFinalBits();
        byte[] bytes = ((ByteArrayOutputStream)this.stream).toByteArray();
        if (bytes.length < 32766) {
            this.sendBytesToPlayer(bytes, player);
        } else {
            int packets = (int)Math.ceil((float)bytes.length / 32766.0f);
            bytes[0] = (byte)packets;
            for (int i = 0; i < packets; ++i) {
                int start = i * 32766;
                int len = Math.min(32766, bytes.length - start);
                byte[] packetBytes = new byte[len];
                System.arraycopy(bytes, start, packetBytes, 0, len);
                this.sendBytesToPlayer(packetBytes, player);
            }
        }
    }

    private void sendBytesToPlayer(byte[] bytes, EntityPlayerMP player) {
        HardcoreQuesting.packetHandler.sendTo(this.createPacket(bytes), player);
    }

    void writeFinalBits() {
        if (this.bitCountBuffer > 0) {
            try {
                this.stream.write(this.byteBuffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bitCountBuffer = 0;
        }
    }

    private FMLProxyPacket createPacket() {
        this.writeFinalBits();
        return this.createPacket(((ByteArrayOutputStream)this.stream).toByteArray());
    }

    private FMLProxyPacket createPacket(byte[] bytes) {
        ByteBuf buf = Unpooled.copiedBuffer((byte[])bytes);
        return new FMLProxyPacket(buf, "hcQuesting");
    }

    public void sendToServer() {
        HardcoreQuesting.packetHandler.sendToServer(this.createPacket());
    }

    public void sendToAllPlayers() {
        HardcoreQuesting.packetHandler.sendToAll(this.createPacket());
    }

    public void sendToAllPlayersAround(TileEntity te, double range) {
        HardcoreQuesting.packetHandler.sendToAllAround(this.createPacket(), new NetworkRegistry.TargetPoint(te.func_145831_w().field_73011_w.field_76574_g, (double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e, range));
    }

    public void createBuffer(DataBitHelper bits) {
        this.buffer = new DataWriter();
        this.bufferSize = bits;
    }

    public void flushBuffer() {
        DataWriter buffer = this.buffer;
        this.buffer = null;
        buffer.writeFinalBits();
        int count = buffer.bits;
        byte[] bytes = ((ByteArrayOutputStream)buffer.stream).toByteArray();
        this.writeData(count, this.bufferSize);
        this.bufferSize = null;
        for (byte b : bytes) {
            int bitCount = Math.min(8, count);
            count -= bitCount;
            this.writeData((int)b, bitCount);
        }
        buffer.close();
    }

    public void writeItemStack(ItemStack itemStack, boolean useSize) {
        this.writeItem(itemStack.func_77973_b());
        if (useSize) {
            this.writeData(itemStack.field_77994_a, DataBitHelper.SHORT);
        }
        this.writeData(itemStack.func_77960_j(), DataBitHelper.SHORT);
        this.writeNBT(itemStack.func_77978_p());
    }

    public void writeItem(Item item) {
        this.writeString(Item.field_150901_e.func_148750_c((Object)item), DataBitHelper.SHORT);
    }

    public void writeEnum(Enum data) {
        try {
            Class clazz = data.getDeclaringClass();
            int length = ((Object[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0])).length;
            if (length == 0) {
                return;
            }
            int bitCount = (int)(Math.log10(length) / Math.log10(2.0)) + 1;
            this.writeData(data.ordinal(), bitCount);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

