/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.IvWorldData;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.commands.RCCommands;
import ivorius.reccomplex.entities.StructureEntityInfo;
import ivorius.reccomplex.network.PacketEditStructureHandler;
import ivorius.reccomplex.structures.StructureInfo;
import ivorius.reccomplex.structures.StructureRegistry;
import ivorius.reccomplex.structures.generic.GenericStructureInfo;
import ivorius.reccomplex.utils.ServerTranslations;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;

public class CommandExportStructure
extends CommandBase {
    public String func_71517_b() {
        return RCConfig.commandPrefix + "export";
    }

    public String func_71518_a(ICommandSender var1) {
        return ServerTranslations.usage("commands.strucExport.usage");
    }

    public void func_71515_b(ICommandSender commandSender, String[] args) {
        boolean saveAsActive;
        String structureID;
        GenericStructureInfo genericStructureInfo;
        EntityPlayerMP player = CommandExportStructure.func_71521_c((ICommandSender)commandSender);
        StructureEntityInfo structureEntityInfo = RCCommands.getStructureEntityInfo((Entity)player);
        if (!structureEntityInfo.hasValidSelection()) {
            throw ServerTranslations.wrongUsageException("commands.selectModify.noSelection", new Object[0]);
        }
        BlockCoord smaller = structureEntityInfo.selectedPoint1.getLowerCorner(structureEntityInfo.selectedPoint2);
        BlockCoord bigger = structureEntityInfo.selectedPoint1.getHigherCorner(structureEntityInfo.selectedPoint2);
        int x = smaller.x;
        int y = smaller.y;
        int z = smaller.z;
        int width = bigger.x - smaller.x + 1;
        int height = bigger.y - smaller.y + 1;
        int length = bigger.z - smaller.z + 1;
        if (args.length >= 1) {
            genericStructureInfo = CommandExportStructure.getGenericStructureInfo(args[0]);
            structureID = args[0];
            saveAsActive = StructureRegistry.isStructureGenerating(structureID);
        } else {
            genericStructureInfo = GenericStructureInfo.createDefaultStructure();
            structureID = "NewStructure";
            saveAsActive = false;
        }
        BlockCoord lowerCoord = new BlockCoord(x, y, z);
        BlockCoord higherCoord = new BlockCoord(x + width - 1, y + height - 1, z + length - 1);
        IvWorldData data = new IvWorldData(player.func_130014_f_(), new BlockArea(lowerCoord, higherCoord), true);
        genericStructureInfo.worldDataCompound = data.createTagCompound(lowerCoord);
        PacketEditStructureHandler.openEditStructure(genericStructureInfo, structureID, saveAsActive, player);
    }

    public List func_71516_a(ICommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return CommandExportStructure.func_71531_a((String[])args, StructureRegistry.allStructureIDs());
        }
        return null;
    }

    public static GenericStructureInfo getGenericStructureInfo(String name) {
        StructureInfo structureInfo = StructureRegistry.getStructure(name);
        if (structureInfo == null) {
            throw ServerTranslations.commandException("commands.structure.notRegistered", name);
        }
        GenericStructureInfo genericStructureInfo = structureInfo.copyAsGenericStructureInfo();
        if (genericStructureInfo == null) {
            throw ServerTranslations.commandException("commands.structure.notGeneric", name);
        }
        return genericStructureInfo;
    }
}

