/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editmazeblock;

import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.reccomplex.gui.editmazeblock.TableDataSourceMazePath;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDataSourceList;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.maze.SavedMazePath;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;

public class TableDataSourceMazePathList
extends TableDataSourceList<SavedMazePath, List<SavedMazePath>> {
    private int[] boundsLower;
    private int[] boundsHigher;

    public TableDataSourceMazePathList(List<SavedMazePath> list, TableDelegate tableDelegate, TableNavigator navigator, int[] boundsLower, int[] boundsHigher) {
        super(list, tableDelegate, navigator);
        this.boundsLower = boundsLower;
        this.boundsHigher = boundsHigher;
        this.setEarlierTitle("Up");
        this.setLaterTitle("Down");
    }

    @Override
    public String getDisplayString(SavedMazePath mazePath) {
        return String.format("%s %s%s%s", Arrays.toString(mazePath.sourceRoom.getCoordinates()), EnumChatFormatting.BLUE, TableDataSourceMazePath.directionFromPath(mazePath).toString(), EnumChatFormatting.RESET);
    }

    @Override
    public SavedMazePath newEntry(String actionID) {
        return new SavedMazePath(2, new MazeRoom(new int[this.boundsLower.length]), false, "Path");
    }

    @Override
    public TableDataSource editEntryDataSource(SavedMazePath entry) {
        return new TableDataSourceMazePath(entry, this.boundsLower, this.boundsHigher);
    }
}

