/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.structures.generic.BiomeGenerationInfo;
import ivorius.reccomplex.utils.IvTranslations;

public class TableDataSourceBiomeGen
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private BiomeGenerationInfo generationInfo;
    private TableDelegate tableDelegate;

    public TableDataSourceBiomeGen(BiomeGenerationInfo generationInfo, TableDelegate tableDelegate) {
        this.generationInfo = generationInfo;
        this.tableDelegate = tableDelegate;
        this.addManagedSection(0, TableDataSourceExpression.constructDefault("Biomes", generationInfo.getBiomeMatcher()));
    }

    @Override
    public int numberOfSegments() {
        return 2;
    }

    @Override
    public int sizeOfSegment(int segment) {
        return segment == 1 ? 1 : super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        if (segment == 1) {
            TableCellFloatNullable cell = new TableCellFloatNullable("weight", TableElements.toFloat(this.generationInfo.getGenerationWeight()), 1.0f, 0.0f, 10.0f, "D", "C");
            cell.addPropertyListener(this);
            cell.setTooltip(IvTranslations.formatLines("structures.gui.random.weight.tooltip", new Object[0]));
            return new TableElementCell(IvTranslations.get("structures.gui.random.weight"), cell);
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if ("weight".equals(cell.getID())) {
            this.generationInfo.setGenerationWeight(TableElements.toDouble((Float)cell.getPropertyValue()));
        }
    }
}

