/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure;

import ivorius.ivtoolkit.gui.IntegerRange;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellIntegerRange;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.structures.generic.GenericYSelector;
import ivorius.reccomplex.utils.IvTranslations;
import java.util.Arrays;

public class TableDataSourceYSelector
implements TableDataSource,
TableCellPropertyListener {
    public GenericYSelector ySelector;

    public TableDataSourceYSelector(GenericYSelector ySelector) {
        this.ySelector = ySelector;
    }

    @Override
    public int numberOfElements() {
        return 2;
    }

    @Override
    public TableElement elementForIndex(GuiTable table, int index) {
        if (index == 0) {
            TableCellEnum<GenericYSelector.SelectionMode> cell = new TableCellEnum<GenericYSelector.SelectionMode>("ySelType", this.ySelector.selectionMode, TableCellEnum.options(Arrays.asList(GenericYSelector.SelectionMode.values()), "structures.genY.", true));
            cell.addPropertyListener(this);
            return new TableElementCell("Generation Base", cell);
        }
        if (index == 1) {
            TableCellIntegerRange cell = new TableCellIntegerRange("ySelShift", new IntegerRange(this.ySelector.minYShift, this.ySelector.maxYShift), -100, 100);
            cell.setTooltip(IvTranslations.formatLines("reccomplex.structure.randomrange", new Object[0]));
            cell.addPropertyListener(this);
            return new TableElementCell("Y Shift", cell);
        }
        return null;
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "ySelType": {
                    this.ySelector.selectionMode = (GenericYSelector.SelectionMode)((Object)cell.getPropertyValue());
                    break;
                }
                case "ySelShift": {
                    IntegerRange range = (IntegerRange)cell.getPropertyValue();
                    this.ySelector.minYShift = range.getMin();
                    this.ySelector.maxYShift = range.getMax();
                }
            }
        }
    }
}

