/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.editstructure.gentypes;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.Directions;
import ivorius.ivtoolkit.gui.FloatRange;
import ivorius.reccomplex.gui.TableDataSourceExpression;
import ivorius.reccomplex.gui.TableDirections;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceGenerationInfo;
import ivorius.reccomplex.gui.table.GuiTable;
import ivorius.reccomplex.gui.table.TableCellEnum;
import ivorius.reccomplex.gui.table.TableCellFloatNullable;
import ivorius.reccomplex.gui.table.TableCellFloatRange;
import ivorius.reccomplex.gui.table.TableCellInteger;
import ivorius.reccomplex.gui.table.TableCellPropertyDefault;
import ivorius.reccomplex.gui.table.TableCellPropertyListener;
import ivorius.reccomplex.gui.table.TableDataSourceSegmented;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import ivorius.reccomplex.gui.table.TableElementCell;
import ivorius.reccomplex.gui.table.TableElements;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.structures.generic.gentypes.VanillaStructureGenerationInfo;
import ivorius.reccomplex.utils.IvTranslations;
import net.minecraftforge.common.util.ForgeDirection;

public class TableDataSourceVanillaStructureGenerationInfo
extends TableDataSourceSegmented
implements TableCellPropertyListener {
    private TableNavigator navigator;
    private TableDelegate tableDelegate;
    private VanillaStructureGenerationInfo generationInfo;

    public TableDataSourceVanillaStructureGenerationInfo(TableNavigator navigator, TableDelegate tableDelegate, VanillaStructureGenerationInfo generationInfo) {
        this.navigator = navigator;
        this.tableDelegate = tableDelegate;
        this.generationInfo = generationInfo;
        this.addManagedSection(0, new TableDataSourceGenerationInfo(generationInfo));
        this.addManagedSection(4, TableDataSourceExpression.constructDefault("Biomes", generationInfo.biomeMatcher));
    }

    @Override
    public int numberOfSegments() {
        return 6;
    }

    @Override
    public int sizeOfSegment(int segment) {
        switch (segment) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 3;
            }
        }
        return super.sizeOfSegment(segment);
    }

    @Override
    public TableElement elementForIndexInSegment(GuiTable table, int index, int segment) {
        switch (segment) {
            case 1: {
                TableCellEnum<String> cell = new TableCellEnum<String>("type", "village", new TableCellEnum.Option<String>("village", "Village"));
                cell.addPropertyListener(this);
                return new TableElementCell("Type", cell);
            }
            case 2: {
                switch (index) {
                    case 0: {
                        TableCellFloatNullable cell = new TableCellFloatNullable("weight", TableElements.toFloat(this.generationInfo.generationWeight), 1.0f, 0.0f, 10.0f, "D", "C");
                        cell.addPropertyListener(this);
                        cell.setTooltip(IvTranslations.formatLines("structures.gui.random.weight.tooltip", new Object[0]));
                        return new TableElementCell(IvTranslations.get("structures.gui.random.weight"), cell);
                    }
                    case 1: {
                        TableCellEnum<ForgeDirection> cell = new TableCellEnum<ForgeDirection>("front", this.generationInfo.front, TableDirections.getDirectionOptions(Directions.HORIZONTAL));
                        cell.addPropertyListener(this);
                        return new TableElementCell("Front", cell);
                    }
                }
            }
            case 3: {
                switch (index) {
                    case 0: {
                        TableCellFloatRange cell = new TableCellFloatRange("baseLimit", new FloatRange((float)this.generationInfo.minBaseLimit, (float)this.generationInfo.maxBaseLimit), 0.0f, 10.0f, 2);
                        cell.addPropertyListener(this);
                        return new TableElementCell("Amount (p. V.)", cell);
                    }
                    case 1: {
                        TableCellFloatRange cell = new TableCellFloatRange("scaledLimit", new FloatRange((float)this.generationInfo.minScaledLimit, (float)this.generationInfo.maxScaledLimit), 0.0f, 10.0f, 2);
                        cell.addPropertyListener(this);
                        return new TableElementCell("Amount (scaled)", cell);
                    }
                }
                break;
            }
            case 5: {
                switch (index) {
                    case 0: {
                        TableCellInteger cell = new TableCellInteger("spawnX", this.generationInfo.spawnShift.x, -50, 50);
                        cell.addPropertyListener(this);
                        return new TableElementCell("Spawn Shift X", cell);
                    }
                    case 1: {
                        TableCellInteger cell = new TableCellInteger("spawnY", this.generationInfo.spawnShift.y, -50, 50);
                        cell.addPropertyListener(this);
                        return new TableElementCell("Spawn Shift Y", cell);
                    }
                    case 2: {
                        TableCellInteger cell = new TableCellInteger("spawnZ", this.generationInfo.spawnShift.z, -50, 50);
                        cell.addPropertyListener(this);
                        return new TableElementCell("Spawn Shift Z", cell);
                    }
                }
            }
        }
        return super.elementForIndexInSegment(table, index, segment);
    }

    @Override
    public void valueChanged(TableCellPropertyDefault cell) {
        if (cell.getID() != null) {
            switch (cell.getID()) {
                case "weight": {
                    this.generationInfo.generationWeight = TableElements.toDouble((Float)cell.getPropertyValue());
                    break;
                }
                case "baseLimit": {
                    FloatRange baseLimit = (FloatRange)cell.getPropertyValue();
                    this.generationInfo.minBaseLimit = baseLimit.getMin();
                    this.generationInfo.maxBaseLimit = baseLimit.getMax();
                    break;
                }
                case "scaledLimit": {
                    FloatRange baseLimit = (FloatRange)cell.getPropertyValue();
                    this.generationInfo.minScaledLimit = baseLimit.getMin();
                    this.generationInfo.maxScaledLimit = baseLimit.getMax();
                    break;
                }
                case "spawnX": {
                    BlockCoord coord = this.generationInfo.spawnShift;
                    this.generationInfo.spawnShift = new BlockCoord(((Integer)cell.getPropertyValue()).intValue(), coord.y, coord.z);
                    break;
                }
                case "spawnY": {
                    BlockCoord coord = this.generationInfo.spawnShift;
                    this.generationInfo.spawnShift = new BlockCoord(coord.x, ((Integer)cell.getPropertyValue()).intValue(), coord.z);
                    break;
                }
                case "spawnZ": {
                    BlockCoord coord = this.generationInfo.spawnShift;
                    this.generationInfo.spawnShift = new BlockCoord(coord.x, coord.y, ((Integer)cell.getPropertyValue()).intValue());
                    break;
                }
                case "front": {
                    this.generationInfo.front = (ForgeDirection)cell.getPropertyValue();
                }
            }
        }
    }
}

