/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.gui.table;

import gnu.trove.map.hash.TIntObjectHashMap;
import ivorius.ivtoolkit.math.IvMathHelper;
import ivorius.reccomplex.gui.table.Bounds;
import ivorius.reccomplex.gui.table.TableCell;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiTable
extends Gui {
    public static final int HEIGHT_PER_SLOT = 25;
    public static final int SCROLL_BAR_HEIGHT = 27;
    public static final float SCROLL_SPEED = 0.005f;
    private TableDelegate delegate;
    private TableDataSource dataSource;
    private Bounds propertiesBounds;
    private float currentScroll;
    private int cachedMaxIndex;
    private boolean hideScrollbarIfUnnecessary;
    private TIntObjectHashMap<TableElement> cachedElements = new TIntObjectHashMap();
    private List<TableElement> currentElements = new ArrayList<TableElement>();
    private Map<GuiButton, Pair<TableCell, Integer>> buttonMap = new HashMap<GuiButton, Pair<TableCell, Integer>>();
    private GuiButton scrollUpButton;
    private GuiButton scrollDownButton;

    public GuiTable(TableDelegate delegate, TableDataSource dataSource) {
        this.delegate = delegate;
        this.dataSource = dataSource;
    }

    public TableDelegate getDelegate() {
        return this.delegate;
    }

    public void setDelegate(TableDelegate delegate) {
        this.delegate = delegate;
    }

    public TableDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(TableDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public boolean hidesScrollbarIfUnnecessary() {
        return this.hideScrollbarIfUnnecessary;
    }

    public void setHideScrollbarIfUnnecessary(boolean hideScrollbarIfUnnecessary) {
        this.hideScrollbarIfUnnecessary = hideScrollbarIfUnnecessary;
    }

    public void initGui() {
        this.buttonMap.clear();
        for (TableElement element : this.currentElements) {
            element.setHidden(true);
        }
        this.currentElements.clear();
        int roundedScrollIndex = MathHelper.func_76141_d((float)(this.currentScroll + 0.5f));
        this.scrollUpButton = new GuiButton(-1, this.propertiesBounds.getMinX(), this.propertiesBounds.getMinY(), this.propertiesBounds.getWidth() / 2 - 1, 20, "Up");
        this.delegate.addButton(this.scrollUpButton);
        this.scrollDownButton = new GuiButton(-1, this.propertiesBounds.getCenterX() + 1, this.propertiesBounds.getMinY(), this.propertiesBounds.getWidth() / 2 - 1, 20, "Down");
        this.delegate.addButton(this.scrollDownButton);
        int supportedSlotNumber = (this.propertiesBounds.getHeight() - 27) / 25;
        int numberOfElements = this.dataSource.numberOfElements();
        this.cachedMaxIndex = roundedScrollIndex + supportedSlotNumber - 1;
        boolean needsUpScroll = this.canScrollUp();
        boolean needsDownScroll = this.canScrollDown(numberOfElements);
        boolean needsScroll = needsUpScroll || needsDownScroll;
        this.scrollUpButton.field_146124_l = needsUpScroll;
        this.scrollDownButton.field_146124_l = needsDownScroll;
        this.scrollUpButton.field_146125_m = needsScroll || !this.hideScrollbarIfUnnecessary;
        this.scrollDownButton.field_146125_m = needsScroll || !this.hideScrollbarIfUnnecessary;
        int baseY = this.propertiesBounds.getMinY() + 27;
        for (int index = 0; index < supportedSlotNumber && roundedScrollIndex + index < numberOfElements; ++index) {
            boolean initElement;
            TableElement element = (TableElement)this.cachedElements.get(roundedScrollIndex + index);
            boolean bl = initElement = element == null;
            if (initElement) {
                element = this.dataSource.elementForIndex(this, roundedScrollIndex + index);
            }
            if (element == null) {
                throw new NullPointerException("Element not initialized: at " + index);
            }
            int elementY = index * 25;
            element.setBounds(Bounds.fromSize(this.propertiesBounds.getMinX() + 100, this.propertiesBounds.getWidth() - 100, baseY + elementY, 20));
            element.setHidden(false);
            element.initGui(this);
            if (initElement) {
                this.cachedElements.put(roundedScrollIndex + index, (Object)element);
            }
            this.currentElements.add(element);
        }
    }

    public void drawScreen(GuiScreen screen, int mouseX, int mouseY, float partialTicks) {
        for (TableElement element : this.currentElements) {
            String title;
            if (element.isHidden() || (title = element.getTitle()) == null) continue;
            Bounds bounds = element.bounds();
            int stringWidth = screen.field_146297_k.field_71466_p.func_78256_a(title);
            screen.func_73731_b(screen.field_146297_k.field_71466_p, title, bounds.getMinX() - stringWidth - 10, bounds.getCenterY() - 4, -1);
        }
        for (TableElement element : this.currentElements) {
            if (element.isHidden()) continue;
            element.draw(this, mouseX, mouseY, partialTicks);
        }
        for (TableElement element : this.currentElements) {
            if (element.isHidden()) continue;
            element.drawFloating(this, mouseX, mouseY, partialTicks);
        }
    }

    public void updateScreen() {
        for (TableElement element : this.currentElements) {
            element.update(this);
        }
    }

    protected void actionPerformed(GuiButton button) {
        if (button == this.scrollDownButton) {
            this.scrollDownIfPossible();
        } else if (button == this.scrollUpButton) {
            this.scrollUpIfPossible();
        } else {
            Pair<TableCell, Integer> propertyPair = this.buttonMap.get(button);
            if (propertyPair != null) {
                ((TableCell)propertyPair.getLeft()).buttonClicked((Integer)propertyPair.getRight());
            }
        }
    }

    public void handleMouseInput() {
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.currentScroll = IvMathHelper.clamp((float)this.getMinScroll(), (float)(this.currentScroll + (float)(-i) * 0.005f), (float)this.getMaxScroll());
            this.delegate.redrawTable();
        }
    }

    protected boolean keyTyped(char keyChar, int keyCode) {
        for (TableElement element : this.currentElements) {
            if (!element.keyTyped(keyChar, keyCode)) continue;
            return true;
        }
        return false;
    }

    protected void mouseClicked(int x, int y, int button) {
        for (TableElement element : this.currentElements) {
            element.mouseClicked(button, x, y);
        }
    }

    public void addButton(TableCell property, int id, GuiButton button) {
        this.delegate.addButton(button);
        this.buttonMap.put(button, (Pair<TableCell, Integer>)new ImmutablePair((Object)property, (Object)id));
    }

    public Bounds getPropertiesBounds() {
        return this.propertiesBounds;
    }

    public void setPropertiesBounds(Bounds propertiesBounds) {
        this.propertiesBounds = propertiesBounds;
    }

    public void scrollUpIfPossible() {
        if (this.canScrollUp()) {
            this.currentScroll = Math.max(this.currentScroll - 1.0f, this.getMinScroll());
            this.delegate.redrawTable();
        }
    }

    public void scrollDownIfPossible() {
        if (this.canScrollDown()) {
            this.currentScroll = Math.min(this.currentScroll + 1.0f, this.getMaxScroll());
            this.delegate.redrawTable();
        }
    }

    public float getMinScroll() {
        return 0.0f;
    }

    public float getMaxScroll() {
        return this.getMaxScroll(this.dataSource.numberOfElements());
    }

    protected float getMaxScroll(int numberOfElements) {
        return numberOfElements - 1 - (this.cachedMaxIndex - MathHelper.func_76141_d((float)(this.currentScroll + 0.5f)));
    }

    public boolean canScrollUp() {
        return this.currentScroll > this.getMinScroll();
    }

    public boolean canScrollDown() {
        return this.canScrollDown(this.dataSource.numberOfElements());
    }

    protected boolean canScrollDown(int numberOfElements) {
        return this.currentScroll < this.getMaxScroll(numberOfElements);
    }

    public void clearElementCache() {
        this.cachedElements.clear();
    }

    public void drawTooltipRect(List<String> lines, Bounds bounds, int mouseX, int mouseY, FontRenderer font) {
        if (bounds.contains(mouseX, mouseY)) {
            this.drawTooltip(lines, mouseX, mouseY, font);
        }
    }

    public void drawTooltip(List<String> lines, int x, int y, FontRenderer font) {
        if (!lines.isEmpty()) {
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : lines) {
                int l = font.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            if (lines.size() > 1) {
                i1 += 2 + (lines.size() - 1) * 10;
            }
            if (j2 + k > this.propertiesBounds.getWidth()) {
                j2 -= 28 + k;
            }
            if (k2 + i1 + 6 > this.propertiesBounds.getHeight()) {
                k2 = this.propertiesBounds.getHeight() - i1 - 6;
            }
            this.field_73735_i = 300.0f;
            int j1 = -267386864;
            this.func_73733_a(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            this.func_73733_a(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            this.func_73733_a(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.func_73733_a(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            this.func_73733_a(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            this.func_73733_a(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < lines.size(); ++i2) {
                String s1 = lines.get(i2);
                font.func_78261_a(s1, j2, k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            this.field_73735_i = 0.0f;
        }
    }
}

