/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.items;

import ivorius.reccomplex.items.GeneratingItem;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import ivorius.reccomplex.worldgen.inventory.InventoryGenerationHandler;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollection;
import ivorius.reccomplex.worldgen.inventory.WeightedItemCollectionRegistry;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class ItemInventoryGenerationTag
extends Item
implements GeneratingItem {
    public static boolean applyGeneratorToInventory(World world, int x, int y, int z, GeneratingItem generatingItem, ItemStack stack) {
        TileEntity rightClicked = world.func_147438_o(x, y, z);
        if (rightClicked instanceof IInventory) {
            if (!world.field_72995_K) {
                generatingItem.generateInInventory((IInventory)rightClicked, world.field_73012_v, stack, world.field_73012_v.nextInt(((IInventory)rightClicked).func_70302_i_()));
                InventoryGenerationHandler.generateAllTags((IInventory)rightClicked, MCRegistrySpecial.INSTANCE.itemHidingMode(), world.field_73012_v);
            }
            return true;
        }
        return false;
    }

    public static String inventoryGeneratorKey(ItemStack stack) {
        NBTTagCompound nbttagcompound;
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("itemCollectionKey", 8)) {
            return stack.func_77978_p().func_74779_i("itemCollectionKey");
        }
        if (stack.field_77990_d != null && stack.field_77990_d.func_150297_b("display", 10) && (nbttagcompound = stack.field_77990_d.func_74775_l("display")).func_150297_b("Name", 8)) {
            return nbttagcompound.func_74779_i("Name");
        }
        return null;
    }

    public static WeightedItemCollection inventoryGenerator(ItemStack stack) {
        return WeightedItemCollectionRegistry.itemCollection(ItemInventoryGenerationTag.inventoryGeneratorKey(stack));
    }

    public static void setItemStackGeneratorKey(ItemStack stack, String generatorKey) {
        stack.func_77983_a("itemCollectionKey", (NBTBase)new NBTTagString(generatorKey));
    }

    public boolean func_77648_a(ItemStack usedItem, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        return ItemInventoryGenerationTag.applyGeneratorToInventory(world, x, y, z, this, usedItem);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (String key : WeightedItemCollectionRegistry.allItemCollectionKeys()) {
            ItemStack stack = new ItemStack(item);
            ItemInventoryGenerationTag.setItemStackGeneratorKey(stack, key);
            list.add(stack);
        }
    }

    public String func_77653_i(ItemStack stack) {
        String key = ItemInventoryGenerationTag.inventoryGeneratorKey(stack);
        return key != null ? key : super.func_77653_i(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advancedInformation) {
        WeightedItemCollection generator = ItemInventoryGenerationTag.inventoryGenerator(stack);
        if (generator != null) {
            list.add(generator.getDescriptor());
        } else {
            list.add(StatCollector.func_74838_a((String)"inventoryGen.none"));
        }
    }
}

