/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.RecurrentComplex;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;

public class MCRegistrySpecial
implements MCRegistry {
    public static final String HIDDEN_ITEM_TAG = "RC_HIDDEN_ITEM";
    public static final MCRegistrySpecial INSTANCE = new MCRegistrySpecial();
    private final BiMap<String, Item> itemMap = HashBiMap.create();
    private final BiMap<String, Block> blockMap = HashBiMap.create();
    private final Map<String, Class<? extends TileEntity>> tileEntityMap = new HashMap<String, Class<? extends TileEntity>>();
    private ItemHidingRegistry itemHidingRegistry = new ItemHidingRegistry(this);

    public void register(String id, Item item) {
        this.itemMap.put((Object)id, (Object)item);
    }

    public void register(String id, Block block) {
        this.blockMap.put((Object)id, (Object)block);
    }

    public void register(String id, Class<? extends TileEntity> tileEntity) {
        this.tileEntityMap.put(id, tileEntity);
    }

    public ItemHidingRegistry itemHidingMode() {
        return this.itemHidingRegistry;
    }

    public Item itemFromID(String itemID) {
        Item item = (Item)this.itemMap.get((Object)itemID);
        return item != null ? item : (Item)Item.field_150901_e.func_82594_a(itemID);
    }

    public String idFromItem(Item item) {
        String id = (String)this.itemMap.inverse().get((Object)item);
        return id != null ? id : Item.field_150901_e.func_148750_c((Object)item);
    }

    public void modifyItemStackCompound(NBTTagCompound compound, String itemID) {
    }

    public boolean isSafe(Item item) {
        return this.itemMap.isEmpty() || !this.itemMap.containsValue((Object)item);
    }

    public Block blockFromID(String blockID) {
        Block block = (Block)this.blockMap.get((Object)blockID);
        return block != null ? block : Block.func_149684_b((String)blockID);
    }

    public String idFromBlock(Block block) {
        String id = (String)this.blockMap.inverse().get((Object)block);
        return id != null ? id : Block.field_149771_c.func_148750_c((Object)block);
    }

    public boolean isSafe(Block block) {
        return this.blockMap.isEmpty() || !this.blockMap.containsValue((Object)block);
    }

    public TileEntity loadTileEntity(NBTTagCompound compound) {
        try {
            Class<? extends TileEntity> oclass = this.tileEntityMap.get(compound.func_74779_i("id"));
            if (oclass != null) {
                TileEntity tileEntity = oclass.newInstance();
                tileEntity.func_145839_a(compound);
                return tileEntity;
            }
        }
        catch (Throwable e) {
            RecurrentComplex.logger.error("Error loading special TileEntity", e);
        }
        return TileEntity.func_145827_c((NBTTagCompound)compound);
    }

    public boolean isSafe(TileEntity tileEntity) {
        return this.tileEntityMap.isEmpty() || !this.tileEntityMap.containsValue(tileEntity.getClass());
    }

    public static class ItemHidingRegistry
    implements MCRegistry {
        protected MCRegistrySpecial parent;

        public ItemHidingRegistry(MCRegistrySpecial parent) {
            this.parent = parent;
        }

        public Item itemFromID(String itemID) {
            Item item = (Item)this.parent.itemMap.get((Object)itemID);
            return item != null ? Items.field_151044_h : (Item)Item.field_150901_e.func_82594_a(itemID);
        }

        public String idFromItem(Item item) {
            return this.parent.idFromItem(item);
        }

        public String containedItemID(ItemStack stack) {
            return this.parent.idFromItem(this.containedItem(stack));
        }

        public Item containedItem(ItemStack stack) {
            Item hidden = this.hiddenItem(stack);
            return hidden != null ? hidden : stack.func_77973_b();
        }

        @Nullable
        public Item hiddenItem(ItemStack stack) {
            return stack.func_77942_o() && stack.func_77978_p().func_150297_b(MCRegistrySpecial.HIDDEN_ITEM_TAG, 8) ? this.parent.itemFromID(stack.func_77978_p().func_74779_i(MCRegistrySpecial.HIDDEN_ITEM_TAG)) : null;
        }

        public ItemStack constructItemStack(String itemID, int stackSize, int metadata) {
            return this.constructItemStack(this.parent.itemFromID(itemID), stackSize, metadata);
        }

        public ItemStack constructItemStack(Item item, int stackSize, int metadata) {
            String hiddenID = (String)this.parent.itemMap.inverse().get((Object)item);
            if (hiddenID != null) {
                ItemStack stack = new ItemStack(Items.field_151044_h, stackSize, metadata);
                stack.func_77983_a(MCRegistrySpecial.HIDDEN_ITEM_TAG, (NBTBase)new NBTTagString(hiddenID));
                return stack;
            }
            return new ItemStack(item, stackSize, metadata);
        }

        public void modifyItemStackCompound(NBTTagCompound compound, String itemID) {
            Item item = (Item)this.parent.itemMap.get((Object)itemID);
            if (item != null) {
                NBTTagCompound stackNBT;
                if (compound.func_150297_b("tag", 10)) {
                    stackNBT = compound.func_74775_l("tag");
                } else {
                    stackNBT = new NBTTagCompound();
                    compound.func_74782_a("tag", (NBTBase)stackNBT);
                }
                stackNBT.func_74778_a(MCRegistrySpecial.HIDDEN_ITEM_TAG, itemID);
            }
        }

        public Block blockFromID(String blockID) {
            return this.parent.blockFromID(blockID);
        }

        public String idFromBlock(Block block) {
            return this.parent.idFromBlock(block);
        }

        public TileEntity loadTileEntity(NBTTagCompound compound) {
            return this.parent.loadTileEntity(compound);
        }
    }
}

