/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.gentypes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.gui.editstructure.gentypes.TableDataSourceNaturalGenerationInfo;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.generic.BiomeGenerationInfo;
import ivorius.reccomplex.structures.generic.DimensionGenerationInfo;
import ivorius.reccomplex.structures.generic.GenericYSelector;
import ivorius.reccomplex.structures.generic.gentypes.StructureGenerationInfo;
import ivorius.reccomplex.structures.generic.presets.BiomeMatcherPresets;
import ivorius.reccomplex.structures.generic.presets.DimensionMatcherPresets;
import ivorius.reccomplex.utils.PresettedList;
import ivorius.reccomplex.worldgen.StructureGenerationData;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeGenBase;

public class NaturalGenerationInfo
extends StructureGenerationInfo {
    private static Gson gson = NaturalGenerationInfo.createGson();
    public String id = "";
    public final PresettedList<BiomeGenerationInfo> biomeWeights = new PresettedList<BiomeGenerationInfo>(BiomeMatcherPresets.instance(), null);
    public final PresettedList<DimensionGenerationInfo> dimensionWeights = new PresettedList<DimensionGenerationInfo>(DimensionMatcherPresets.instance(), null);
    public String generationCategory;
    public GenericYSelector ySelector;
    private Double generationWeight;
    public SpawnLimitation spawnLimitation;

    public NaturalGenerationInfo() {
        this("NaturalGen1", "decoration", new GenericYSelector(GenericYSelector.SelectionMode.SURFACE, 0, 0));
        this.biomeWeights.setToDefault();
        this.dimensionWeights.setToDefault();
    }

    public NaturalGenerationInfo(String id, String generationCategory, GenericYSelector ySelector) {
        this.id = id;
        this.generationCategory = generationCategory;
        this.ySelector = ySelector;
    }

    public static Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(NaturalGenerationInfo.class, (Object)new Serializer());
        builder.registerTypeAdapter(BiomeGenerationInfo.class, (Object)new BiomeGenerationInfo.Serializer());
        builder.registerTypeAdapter(DimensionGenerationInfo.class, (Object)new DimensionGenerationInfo.Serializer());
        builder.registerTypeAdapter(GenericYSelector.class, (Object)new GenericYSelector.Serializer());
        return builder.create();
    }

    public static Gson getGson() {
        return gson;
    }

    public static NaturalGenerationInfo deserializeFromVersion1(JsonObject jsonObject, JsonDeserializationContext context) {
        String generationCategory = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "generationCategory");
        GenericYSelector ySelector = (GenericYSelector)gson.fromJson(jsonObject.get("generationY"), GenericYSelector.class);
        NaturalGenerationInfo naturalGenerationInfo = new NaturalGenerationInfo("", generationCategory, ySelector);
        if (jsonObject.has("generationBiomes")) {
            BiomeGenerationInfo[] infos = (BiomeGenerationInfo[])gson.fromJson(jsonObject.get("generationBiomes"), BiomeGenerationInfo[].class);
            naturalGenerationInfo.biomeWeights.setContents(Arrays.asList(infos));
        } else {
            naturalGenerationInfo.biomeWeights.setToDefault();
        }
        naturalGenerationInfo.dimensionWeights.setToDefault();
        return naturalGenerationInfo;
    }

    public Double getGenerationWeight() {
        return this.generationWeight;
    }

    public void setGenerationWeight(Double generationWeight) {
        this.generationWeight = generationWeight;
    }

    public double getGenerationWeight(BiomeGenBase biome, WorldProvider provider) {
        return this.getActiveSpawnWeight() * this.generationWeightInBiome(biome) * this.generationWeightInDimension(provider);
    }

    public double generationWeightInDimension(WorldProvider provider) {
        for (DimensionGenerationInfo generationInfo : this.dimensionWeights.list) {
            if (!generationInfo.matches(provider)) continue;
            return generationInfo.getActiveGenerationWeight();
        }
        return 0.0;
    }

    public double generationWeightInBiome(BiomeGenBase biome) {
        for (BiomeGenerationInfo generationInfo : this.biomeWeights.list) {
            if (!generationInfo.matches(biome)) continue;
            return generationInfo.getActiveGenerationWeight();
        }
        return 0.0;
    }

    public double getActiveSpawnWeight() {
        return this.generationWeight != null ? this.generationWeight : 1.0;
    }

    public boolean hasDefaultWeight() {
        return this.generationWeight == null;
    }

    public boolean hasLimitations() {
        return this.spawnLimitation != null;
    }

    public SpawnLimitation getLimitations() {
        return this.spawnLimitation;
    }

    @Override
    @Nonnull
    public String id() {
        return this.id;
    }

    @Override
    public void setID(@Nonnull String id) {
        this.id = id;
    }

    @Override
    public String displayString() {
        return StatCollector.func_74838_a((String)"reccomplex.generationInfo.natural");
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceNaturalGenerationInfo(navigator, delegate, this);
    }

    public static class Serializer
    implements JsonSerializer<NaturalGenerationInfo>,
    JsonDeserializer<NaturalGenerationInfo> {
        public NaturalGenerationInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            GenericYSelector ySelector;
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(json, "naturalGenerationInfo");
            String id = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "id", "");
            String generationCategory = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "generationCategory");
            if (jsonObject.has("generationY")) {
                ySelector = (GenericYSelector)gson.fromJson(jsonObject.get("generationY"), GenericYSelector.class);
            } else {
                RecurrentComplex.logger.warn("Structure JSON missing 'generationY'! Using 'surface'!");
                ySelector = new GenericYSelector(GenericYSelector.SelectionMode.SURFACE, 0, 0);
            }
            NaturalGenerationInfo naturalGenerationInfo = new NaturalGenerationInfo(id, generationCategory, ySelector);
            if (jsonObject.has("generationWeight")) {
                naturalGenerationInfo.generationWeight = JsonUtils.getJsonObjectDoubleFieldValue(jsonObject, "generationWeight");
            }
            Serializer.loadPresettedList(jsonObject, naturalGenerationInfo.biomeWeights, "biomeWeightsPreset", "generationBiomes", BiomeGenerationInfo[].class);
            Serializer.loadPresettedList(jsonObject, naturalGenerationInfo.dimensionWeights, "dimensionWeightsPreset", "generationDimensions", DimensionGenerationInfo[].class);
            if (jsonObject.has("spawnLimitation")) {
                naturalGenerationInfo.spawnLimitation = (SpawnLimitation)context.deserialize(jsonObject.get("spawnLimitation"), SpawnLimitation.class);
            }
            return naturalGenerationInfo;
        }

        public JsonElement serialize(NaturalGenerationInfo src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", src.id);
            jsonObject.addProperty("generationCategory", src.generationCategory);
            if (src.generationWeight != null) {
                jsonObject.addProperty("generationWeight", (Number)src.generationWeight);
            }
            jsonObject.add("generationY", gson.toJsonTree((Object)src.ySelector));
            Serializer.writePresettedList(jsonObject, src.biomeWeights, "biomeWeightsPreset", "generationBiomes");
            Serializer.writePresettedList(jsonObject, src.dimensionWeights, "dimensionWeightsPreset", "generationDimensions");
            if (src.spawnLimitation != null) {
                jsonObject.add("spawnLimitation", context.serialize((Object)src.spawnLimitation));
            }
            return jsonObject;
        }

        protected static <T> void loadPresettedList(JsonObject jsonObject, PresettedList<T> list, String presetKey, String listKey, Class<T[]> clazz) {
            if (!list.setPreset(JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, presetKey, null))) {
                if (jsonObject.has(listKey)) {
                    Collections.addAll(list.list, (Object[])gson.fromJson(jsonObject.get(listKey), clazz));
                } else {
                    list.setToDefault();
                }
            }
        }

        protected static <T> void writePresettedList(JsonObject jsonObject, PresettedList<T> list, String presetKey, String listKey) {
            if (list.getPreset() != null) {
                jsonObject.addProperty(presetKey, list.getPreset());
            }
            jsonObject.add(listKey, gson.toJsonTree(list.list));
        }
    }

    public static class SpawnLimitation {
        public int maxCount = 1;
        public Context context = Context.DIMENSION;

        public boolean areResolved(World world, String structureID) {
            return StructureGenerationData.get(world).getEntriesByID(structureID).size() < this.maxCount;
        }

        public static enum Context {
            DIMENSION;

        }
    }
}

