/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.maze;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import ivorius.ivtoolkit.maze.components.MazeRoomConnection;
import ivorius.ivtoolkit.maze.components.WeightedMazeComponent;
import java.util.Map;
import java.util.Set;

public class MazeComponentStructure<C>
implements WeightedMazeComponent<C> {
    public final ImmutableSet<MazeRoom> rooms;
    public final ImmutableMap<MazeRoomConnection, C> exits;
    public double weight;
    public String structureID;
    public AxisAlignedTransform2D transform;
    private int[] size;

    public MazeComponentStructure(double weight, String structureID, AxisAlignedTransform2D transform, ImmutableSet<MazeRoom> rooms, ImmutableMap<MazeRoomConnection, C> exits) {
        this.weight = weight;
        this.structureID = structureID;
        this.transform = transform;
        this.rooms = rooms;
        this.exits = exits;
    }

    public double getWeight() {
        return this.weight;
    }

    public Set<MazeRoom> rooms() {
        return this.rooms;
    }

    public Map<MazeRoomConnection, C> exits() {
        return this.exits;
    }

    public int[] getSize() {
        int[] lowest = null;
        int[] highest = null;
        for (MazeRoom room : this.rooms) {
            for (int i = 0; i < room.getDimensions(); ++i) {
                if (lowest == null) {
                    lowest = room.getCoordinates();
                    highest = room.getCoordinates();
                    continue;
                }
                if (room.getCoordinate(i) < lowest[i]) {
                    lowest[i] = room.getCoordinate(i);
                    continue;
                }
                if (room.getCoordinate(i) <= highest[i]) continue;
                highest[i] = room.getCoordinate(i);
            }
        }
        if (lowest == null) {
            throw new UnsupportedOperationException();
        }
        int[] size = IvVecMathHelper.sub(highest, (int[][])new int[][]{lowest});
        int i = 0;
        while (i < size.length) {
            int n = i++;
            size[n] = size[n] + 1;
        }
        return size;
    }
}

