/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.structures.generic.transformers;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.reccomplex.gui.editstructure.transformers.TableDataSourceBTPillar;
import ivorius.reccomplex.gui.table.TableDataSource;
import ivorius.reccomplex.gui.table.TableDelegate;
import ivorius.reccomplex.gui.table.TableNavigator;
import ivorius.reccomplex.json.JsonUtils;
import ivorius.reccomplex.structures.MCRegistrySpecial;
import ivorius.reccomplex.structures.StructureLoadContext;
import ivorius.reccomplex.structures.StructurePrepareContext;
import ivorius.reccomplex.structures.StructureSpawnContext;
import ivorius.reccomplex.structures.generic.matchers.BlockMatcher;
import ivorius.reccomplex.structures.generic.transformers.Transformer;
import ivorius.reccomplex.structures.generic.transformers.TransformerReplace;
import ivorius.reccomplex.structures.generic.transformers.TransformerSingleBlock;
import ivorius.reccomplex.utils.NBTNone;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TransformerPillar
extends TransformerSingleBlock<NBTNone> {
    public BlockMatcher sourceMatcher;
    public Block destBlock;
    public int destMetadata;

    public TransformerPillar() {
        this(BlockMatcher.of((MCRegistry)MCRegistrySpecial.INSTANCE, Blocks.field_150348_b, 0), Blocks.field_150348_b, 0);
    }

    public TransformerPillar(String sourceExpression, Block destBlock, int destMetadata) {
        this.sourceMatcher = new BlockMatcher(MCRegistrySpecial.INSTANCE, sourceExpression);
        this.destBlock = destBlock;
        this.destMetadata = destMetadata;
    }

    @Override
    public boolean matches(NBTNone instanceData, Block block, int metadata) {
        return this.sourceMatcher.apply(new BlockMatcher.BlockFragment(block, metadata));
    }

    @Override
    public void transformBlock(NBTNone instanceData, Transformer.Phase phase, StructureSpawnContext context, BlockCoord coord, Block sourceBlock, int sourceMetadata) {
        if (MCRegistrySpecial.INSTANCE.isSafe(this.destBlock)) {
            Block block;
            World world = context.world;
            int y = coord.y;
            do {
                context.setBlock(coord.x, y--, coord.z, this.destBlock, this.destMetadata);
            } while (((block = world.func_147439_a(coord.x, y, coord.z)).isReplaceable((IBlockAccess)world, coord.x, y, coord.z) || block.func_149688_o() == Material.field_151584_j || block.isFoliage((IBlockAccess)world, coord.x, y, coord.z)) && y > 0);
        }
    }

    @Override
    public NBTNone prepareInstanceData(StructurePrepareContext context) {
        return new NBTNone();
    }

    @Override
    public NBTNone loadInstanceData(StructureLoadContext context, NBTBase nbt) {
        return new NBTNone();
    }

    @Override
    public String getDisplayString() {
        return "Pillar: " + this.sourceMatcher.getDisplayString() + "->" + this.destBlock.func_149732_F();
    }

    @Override
    public TableDataSource tableDataSource(TableNavigator navigator, TableDelegate delegate) {
        return new TableDataSourceBTPillar(this);
    }

    @Override
    public boolean generatesInPhase(NBTNone instanceData, Transformer.Phase phase) {
        return phase == Transformer.Phase.BEFORE;
    }

    public static class Serializer
    implements JsonDeserializer<TransformerPillar>,
    JsonSerializer<TransformerPillar> {
        private MCRegistry registry;

        public Serializer(MCRegistry registry) {
            this.registry = registry;
        }

        public TransformerPillar deserialize(JsonElement jsonElement, Type par2Type, JsonDeserializationContext context) {
            JsonObject jsonObject = JsonUtils.getJsonElementAsJsonObject(jsonElement, "transformerPillar");
            String expression = TransformerReplace.Serializer.readLegacyMatcher(jsonObject, "source", "sourceMetadata");
            if (expression == null) {
                expression = JsonUtils.getJsonObjectStringFieldValueOrDefault(jsonObject, "sourceExpression", "");
            }
            String destBlock = JsonUtils.getJsonObjectStringFieldValue(jsonObject, "dest");
            Block dest = this.registry.blockFromID(destBlock);
            int destMeta = JsonUtils.getJsonObjectIntegerFieldValue(jsonObject, "destMetadata");
            return new TransformerPillar(expression, dest, destMeta);
        }

        public JsonElement serialize(TransformerPillar transformer, Type par2Type, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("sourceExpression", transformer.sourceMatcher.getExpression());
            jsonObject.addProperty("dest", this.registry.idFromBlock(transformer.destBlock));
            jsonObject.addProperty("destMetadata", (Number)transformer.destMetadata);
            return jsonObject;
        }
    }
}

